/*
 * Decompiled with CFR 0.152.
 */
package com.example.config;

import com.example.LayeredChunks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_10594;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2521;
import net.minecraft.class_2526;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class TerrainConfig {
    private static final Set<class_2248> BLACKLISTED_BLOCKS = new HashSet<class_2248>();
    private static final Map<class_5321<class_1937>, Set<class_2248>> ENVIRONMENT_BLACKLISTS = new HashMap<class_5321<class_1937>, Set<class_2248>>();
    private static final Map<class_5321<class_1937>, Map<Integer, class_2248>> FORCED_BLOCKS = new HashMap<class_5321<class_1937>, Map<Integer, class_2248>>();
    private static List<class_2248> cachedValidBlocks = null;

    private static void initializeEnvironmentBlacklists() {
        HashSet<class_2248> netherBlacklist = new HashSet<class_2248>();
        netherBlacklist.add(class_2246.field_10295);
        netherBlacklist.add(class_2246.field_10225);
        netherBlacklist.add(class_2246.field_10384);
        netherBlacklist.add(class_2246.field_10477);
        netherBlacklist.add(class_2246.field_10491);
        netherBlacklist.add(class_2246.field_27879);
        netherBlacklist.add(class_2246.field_10375);
        ENVIRONMENT_BLACKLISTS.put((class_5321<class_1937>)class_1937.field_25180, netherBlacklist);
        HashSet<class_2248> endBlacklist = new HashSet<class_2248>();
        endBlacklist.add(class_2246.field_10515);
        endBlacklist.add(class_2246.field_10382);
        endBlacklist.add(class_2246.field_22090);
        endBlacklist.add(class_2246.field_22120);
        endBlacklist.add(class_2246.field_22113);
        ENVIRONMENT_BLACKLISTS.put((class_5321<class_1937>)class_1937.field_25181, endBlacklist);
        ENVIRONMENT_BLACKLISTS.put((class_5321<class_1937>)class_1937.field_25179, Set.of(class_2246.field_10164, class_2246.field_10375));
    }

    public static List<class_2248> getValidBlocks() {
        if (cachedValidBlocks == null) {
            cachedValidBlocks = class_7923.field_41175.method_10220().filter(block -> !BLACKLISTED_BLOCKS.contains(block)).filter(TerrainConfig::isFullSolidBlock).collect(Collectors.toList());
            System.out.println("[OneBlockChunk] Cached " + cachedValidBlocks.size() + " valid solid blocks for chunk generation");
        }
        return cachedValidBlocks;
    }

    private static boolean isFullSolidBlock(class_2248 block) {
        if (block == class_2246.field_10382 || block == class_2246.field_10164 || block == class_2246.field_10114 || block == LayeredChunks.DECORATIVE_SKULL_BLOCK) {
            return true;
        }
        class_2680 state = block.method_9564();
        class_265 shape = state.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980);
        return shape.equals((Object)class_259.method_1077());
    }

    public static boolean isBlacklisted(class_2248 block) {
        return BLACKLISTED_BLOCKS.contains(block);
    }

    public static void addToBlacklist(class_2248 block) {
        BLACKLISTED_BLOCKS.add(block);
    }

    public static void addToEnvironmentBlacklist(class_5321<class_1937> dimension, class_2248 block) {
        ENVIRONMENT_BLACKLISTS.computeIfAbsent(dimension, k -> new HashSet()).add(block);
    }

    public static void removeFromEnvironmentBlacklist(class_5321<class_1937> dimension, class_2248 block) {
        Set<class_2248> blacklist = ENVIRONMENT_BLACKLISTS.get(dimension);
        if (blacklist != null) {
            blacklist.remove(block);
        }
    }

    public static boolean isBlacklistedInEnvironment(class_5321<class_1937> dimension, class_2248 block) {
        Set<class_2248> blacklist = ENVIRONMENT_BLACKLISTS.get(dimension);
        return blacklist != null && blacklist.contains(block);
    }

    public static void setForcedBlock(class_5321<class_1937> dimension, int yLevel, class_2248 block) {
        FORCED_BLOCKS.computeIfAbsent(dimension, k -> new HashMap()).put(yLevel, block);
        System.out.println("[OneBlockChunk] Forced block " + String.valueOf(block) + " at Y=" + yLevel + " in dimension " + String.valueOf(dimension.method_29177()));
    }

    public static class_2248 getForcedBlock(class_5321<class_1937> dimension, int yLevel) {
        Map<Integer, class_2248> dimensionForcedBlocks = FORCED_BLOCKS.get(dimension);
        if (dimensionForcedBlocks != null) {
            return dimensionForcedBlocks.get(yLevel);
        }
        return null;
    }

    public static void removeForcedBlock(class_5321<class_1937> dimension, int yLevel) {
        Map<Integer, class_2248> dimensionForcedBlocks = FORCED_BLOCKS.get(dimension);
        if (dimensionForcedBlocks != null) {
            dimensionForcedBlocks.remove(yLevel);
            if (dimensionForcedBlocks.isEmpty()) {
                FORCED_BLOCKS.remove(dimension);
            }
        }
    }

    public static void clearForcedBlocksForDimension(class_5321<class_1937> dimension) {
        FORCED_BLOCKS.remove(dimension);
    }

    public static List<class_2248> getValidBlocksForEnvironment(class_5321<class_1937> dimension) {
        Set<class_2248> envBlacklist = ENVIRONMENT_BLACKLISTS.get(dimension);
        return class_7923.field_41175.method_10220().filter(block -> !BLACKLISTED_BLOCKS.contains(block)).filter(block -> envBlacklist == null || !envBlacklist.contains(block)).filter(TerrainConfig::isFullSolidBlock).collect(Collectors.toList());
    }

    static {
        BLACKLISTED_BLOCKS.add(class_2246.field_10124);
        BLACKLISTED_BLOCKS.add(class_2246.field_10543);
        BLACKLISTED_BLOCKS.add(class_2246.field_10243);
        BLACKLISTED_BLOCKS.add(class_2246.field_29029);
        BLACKLISTED_BLOCKS.add(class_2246.field_10442);
        BLACKLISTED_BLOCKS.add(class_2246.field_10201);
        BLACKLISTED_BLOCKS.add(class_2246.field_10499);
        BLACKLISTED_BLOCKS.add(class_2246.field_10369);
        BLACKLISTED_BLOCKS.add(class_2246.field_10465);
        BLACKLISTED_BLOCKS.add(class_2246.field_16540);
        BLACKLISTED_BLOCKS.add(class_2246.field_10525);
        BLACKLISTED_BLOCKS.add(class_2246.field_10395);
        BLACKLISTED_BLOCKS.add(class_2246.field_10263);
        BLACKLISTED_BLOCKS.add(class_2246.field_31037);
        BLACKLISTED_BLOCKS.add(class_2246.field_55985);
        BLACKLISTED_BLOCKS.add(class_2246.field_55984);
        BLACKLISTED_BLOCKS.add(class_2246.field_9987);
        BLACKLISTED_BLOCKS.add(class_2246.field_10327);
        BLACKLISTED_BLOCKS.add(class_2246.field_38420);
        BLACKLISTED_BLOCKS.add(class_2246.field_10316);
        BLACKLISTED_BLOCKS.add(class_2246.field_10027);
        BLACKLISTED_BLOCKS.add(class_2246.field_10398);
        BLACKLISTED_BLOCKS.add(class_2246.field_10613);
        BLACKLISTED_BLOCKS.add(class_2246.field_10260);
        BLACKLISTED_BLOCKS.add(class_2246.field_47336);
        BLACKLISTED_BLOCKS.add(class_2246.field_48851);
        BLACKLISTED_BLOCKS.add(class_2246.field_10036);
        BLACKLISTED_BLOCKS.add(class_2246.field_22089);
        BLACKLISTED_BLOCKS.add(class_2246.field_10422);
        BLACKLISTED_BLOCKS.add(class_2246.field_10528);
        BLACKLISTED_BLOCKS.add(class_2246.field_10021);
        BLACKLISTED_BLOCKS.add(class_2246.field_37546);
        BLACKLISTED_BLOCKS.add(class_2246.field_9980);
        BLACKLISTED_BLOCKS.add(class_2246.field_10181);
        BLACKLISTED_BLOCKS.add(class_2246.field_16333);
        BLACKLISTED_BLOCKS.add(class_2246.field_46797);
        BLACKLISTED_BLOCKS.add(class_2246.field_16334);
        BLACKLISTED_BLOCKS.add(class_2246.field_16329);
        class_7923.field_41175.method_10220().filter(block -> block.method_63499().endsWith("shulker_box") || block.method_63499().endsWith("leaves") || block.method_63499().endsWith("chest") || block.method_63499().endsWith("glass") || block.method_63499().endsWith("powder") || block.method_63499().endsWith("powder") || block instanceof class_2521 || block instanceof class_10594 || block instanceof class_2362 || block instanceof class_2526).forEach(block -> {
            BLACKLISTED_BLOCKS.add((class_2248)block);
            System.out.println("Blacklisting " + String.valueOf(block));
        });
        BLACKLISTED_BLOCKS.add(class_2246.field_10102);
        BLACKLISTED_BLOCKS.add(class_2246.field_10534);
        BLACKLISTED_BLOCKS.add(class_2246.field_10255);
        BLACKLISTED_BLOCKS.add(class_2246.field_43227);
        BLACKLISTED_BLOCKS.add(class_2246.field_42728);
        BLACKLISTED_BLOCKS.add(class_2246.field_10535);
        BLACKLISTED_BLOCKS.add(class_2246.field_10105);
        BLACKLISTED_BLOCKS.add(class_2246.field_10414);
        BLACKLISTED_BLOCKS.add(class_2246.field_10081);
        BLACKLISTED_BLOCKS.add(class_2246.field_16492);
        TerrainConfig.initializeEnvironmentBlacklists();
    }
}

