/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldgen;

import com.example.config.TerrainConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2248;

public class ChunkBlockSelector {
    private static List<class_2248> validBlocks;

    private static List<class_2248> getValidBlocks() {
        if (validBlocks == null) {
            validBlocks = TerrainConfig.getValidBlocks();
        }
        return validBlocks;
    }

    public static class_2248 selectBlockForChunk(int chunkX, int chunkZ) {
        List<class_2248> blocks = ChunkBlockSelector.getValidBlocks();
        if (blocks.isEmpty()) {
            throw new IllegalStateException("No valid blocks available for chunk generation!");
        }
        long seed = ChunkBlockSelector.getSeedFromChunkCoords(chunkX, chunkZ);
        Random random = new Random(seed);
        int index = random.nextInt(blocks.size());
        return blocks.get(index);
    }

    public static long getSeedFromChunkCoords(int chunkX, int chunkZ) {
        long hash = (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L;
        hash ^= hash >> 16;
        return hash;
    }
}

