/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldgen;

import com.example.config.TerrainConfig;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_5321;

public class YLevelBlockSelector {
    public static final int MIN_Y_LEVEL = -64;
    public static final int MAX_Y_LEVEL = 320;
    private static final Map<class_5321<class_1937>, Map<Integer, class_2248>> yLevelBlockCache = new ConcurrentHashMap<class_5321<class_1937>, Map<Integer, class_2248>>();
    private static volatile Long cachedWorldSeed = null;
    private static List<class_2248> validBlocks;

    private static List<class_2248> getValidBlocks() {
        if (validBlocks == null) {
            validBlocks = TerrainConfig.getValidBlocks();
        }
        return validBlocks;
    }

    public static class_2248 selectBlockForYLevel(int yLevel, long worldSeed) {
        return YLevelBlockSelector.selectBlockForYLevel(yLevel, worldSeed, null);
    }

    public static class_2248 selectBlockForYLevel(int yLevel, long worldSeed, class_5321<class_1937> dimension) {
        class_2248 cachedBlock;
        Map<Integer, class_2248> dimensionCache;
        class_2248 forcedBlock;
        if (yLevel < -64 || yLevel > 320) {
            throw new IllegalArgumentException("Y-level " + yLevel + " out of range [-64, 320]");
        }
        if (dimension != null && (forcedBlock = TerrainConfig.getForcedBlock(dimension, yLevel)) != null) {
            return forcedBlock;
        }
        if (cachedWorldSeed == null || !cachedWorldSeed.equals(worldSeed)) {
            YLevelBlockSelector.clearCache();
            cachedWorldSeed = worldSeed;
        }
        if (dimension != null && (dimensionCache = yLevelBlockCache.get(dimension)) != null && (cachedBlock = dimensionCache.get(yLevel)) != null) {
            return cachedBlock;
        }
        List<class_2248> blocks = dimension != null ? TerrainConfig.getValidBlocksForEnvironment(dimension) : YLevelBlockSelector.getValidBlocks();
        if (blocks.isEmpty()) {
            throw new IllegalStateException("No valid blocks available for Y-level generation!");
        }
        long seed = YLevelBlockSelector.generateSeedFromYLevel(yLevel, worldSeed, dimension);
        Random random = new Random(seed);
        int index = random.nextInt(blocks.size());
        class_2248 selectedBlock = blocks.get(index);
        if (dimension != null) {
            yLevelBlockCache.computeIfAbsent(dimension, k -> new ConcurrentHashMap()).put(yLevel, selectedBlock);
        }
        return selectedBlock;
    }

    private static long generateSeedFromYLevel(int yLevel, long worldSeed, class_5321<class_1937> dimension) {
        long dimensionSalt = 0L;
        if (dimension != null) {
            dimensionSalt = dimension.method_29177().toString().hashCode();
        }
        long hash = worldSeed ^ (long)yLevel * 486187739L ^ dimensionSalt * 982451653L;
        hash ^= hash >>> 33;
        hash *= -49064778989728563L;
        hash ^= hash >>> 33;
        hash *= -4265267296055464877L;
        hash ^= hash >>> 33;
        return hash;
    }

    public static void clearCache() {
        yLevelBlockCache.clear();
        cachedWorldSeed = null;
    }

    public static int getCacheSize() {
        return yLevelBlockCache.values().stream().mapToInt(Map::size).sum();
    }
}

