/*
 * Decompiled with CFR 0.152.
 */
package net.tarminarx.trxluckyclover;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.BooleanValue ENABLE_CLOVER_TRADE = BUILDER.comment("Whether the Master Cleric should trade the Four Leaf Clover.").define("enableCloverTrade", true);
    public static final ModConfigSpec.ConfigValue<? extends String> TRADE_ITEM = BUILDER.comment("The item to use as a cost for the trade in the Master Cleric's trade.").define("tradeItem", (Object)"minecraft:emerald", Config::validateItemName);
    public static final ModConfigSpec.IntValue TRADE_ITEM_COUNT = BUILDER.comment("The number of items required for the trade in the Master Cleric's trade.").defineInRange("tradeItemCount", 50, 1, Integer.MAX_VALUE);
    public static final ModConfigSpec.DoubleValue LUCK_MULTIPLIER_CLOVER = BUILDER.comment("Defines the multiplier to use per number of clover in the player's inventory.").defineInRange("luckMultiplier", 1.0, 0.0, Double.MAX_VALUE);
    public static final ModConfigSpec.BooleanValue ENABLE_LOOT_TABLE_DROPS = BUILDER.comment("Whether the Four Leaf Clover should be added to loot chests (Village, Barrels, etc.)").define("enableLootTableDrops", true);
    public static final ModConfigSpec.DoubleValue CLOVER_CHANCE = BUILDER.comment("The chance for a Four Leaf Clover to appear in loot (0.0 to 1.0)").defineInRange("cloverLootChance", 0.1, 0.0, 1.0);
    public static final ModConfigSpec.DoubleValue LOOT_LUCK_MULTIPLIER = BUILDER.comment("Defines the multiplier to use per number of clover in the player's inventory for loot chests").comment("Only affects the chance of the four leaf clover to appear in chests.").defineInRange("lootLuckMultiplier", 0.01, 0.0, Double.MAX_VALUE);
    public static final ModConfigSpec.IntValue MAX_CLOVER_IN_LOOT = BUILDER.comment("The maximum number of clovers that can appear in a single loot chests.").defineInRange("maxCloverInLoot", 1, 1, Integer.MAX_VALUE);
    static final ModConfigSpec SPEC = BUILDER.build();

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }
}

