/*
 * Decompiled with CFR 0.152.
 */
package net.tarminarx.trxluckyclover.event;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.tarminarx.trxluckyclover.Config;
import net.tarminarx.trxluckyclover.item.custom.FourLeafClover;

@EventBusSubscriber(modid="trxluckyclover", value={Dist.CLIENT})
public class ModClientEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        double cloverLuck;
        ItemStack stack = event.getItemStack();
        if (!(stack.getItem() instanceof FourLeafClover)) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        AttributeInstance luckAttr = player.getAttribute(Attributes.LUCK);
        if (luckAttr == null) {
            return;
        }
        AttributeModifier cloverMod = luckAttr.getModifier(FourLeafClover.CLOVER_LUCK_ID);
        double d = cloverLuck = cloverMod != null ? cloverMod.amount() : 0.0;
        if (cloverLuck > 0.0) {
            event.getToolTip().add(Component.translatable((String)"tooltip.trxluckyclover.fleafclover.currentluck", (Object[])new Object[]{cloverLuck}).withStyle(ChatFormatting.GREEN));
        }
        event.getToolTip().add(Component.translatable((String)"tooltip.trxluckyclover.fleafclover.description", (Object[])new Object[]{Config.LUCK_MULTIPLIER_CLOVER.get()}));
    }
}

