/*
 * Decompiled with CFR 0.152.
 */
package net.tarminarx.trxluckyclover.event;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.tarminarx.trxluckyclover.Config;
import net.tarminarx.trxluckyclover.item.ModItems;
import net.tarminarx.trxluckyclover.item.custom.FourLeafClover;

@EventBusSubscriber(modid="trxluckyclover")
public class ModEvents {
    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (((Boolean)Config.ENABLE_CLOVER_TRADE.get()).booleanValue() && event.getType() == VillagerProfession.CLERIC) {
            List trades = (List)event.getTrades().get(5);
            trades.add((merchant, random) -> {
                Item configuredItem = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)((String)Config.TRADE_ITEM.get()))).orElse(Items.EMERALD);
                return new MerchantOffer(new ItemCost((ItemLike)configuredItem, ((Integer)Config.TRADE_ITEM_COUNT.get()).intValue()), new ItemStack((ItemLike)ModItems.LEAFCLOVER.get(), 1), 10, 30, 0.05f);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        double cloverCount = 0.0;
        for (ItemStack itemStack : player.getInventory().items) {
            if (!(itemStack.getItem() instanceof FourLeafClover)) continue;
            cloverCount += (Double)Config.LUCK_MULTIPLIER_CLOVER.get() * (double)itemStack.getCount();
        }
        AttributeInstance luckAttribute = player.getAttribute(Attributes.LUCK);
        if (luckAttribute != null) {
            AttributeModifier currentLuckMod = luckAttribute.getModifier(FourLeafClover.CLOVER_LUCK_ID);
            if (cloverCount > 0.0) {
                AttributeModifier updated = new AttributeModifier(FourLeafClover.CLOVER_LUCK_ID, cloverCount, AttributeModifier.Operation.ADD_VALUE);
                if (currentLuckMod == null || currentLuckMod.amount() != cloverCount) {
                    luckAttribute.removeModifier(FourLeafClover.CLOVER_LUCK_ID);
                    luckAttribute.addOrReplacePermanentModifier(updated);
                }
            } else if (currentLuckMod != null) {
                luckAttribute.removeModifier(FourLeafClover.CLOVER_LUCK_ID);
            }
        }
    }
}

