/*
 * Decompiled with CFR 0.152.
 */
package net.tarminarx.trxluckyclover.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.tarminarx.trxluckyclover.Config;

public class AddItemModifier
extends LootModifier {
    public static final MapCodec<AddItemModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(e -> e.item)).apply((Applicative)instance, AddItemModifier::new));
    private final Item item;

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item item) {
        super(conditionsIn);
        this.item = item;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)Config.ENABLE_LOOT_TABLE_DROPS.get()).booleanValue()) {
            Player player;
            double luck;
            double baseChance;
            double randNumber = context.getRandom().nextDouble();
            double finalChance = baseChance = ((Double)Config.CLOVER_CHANCE.get()).doubleValue();
            Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
            if (entity instanceof Player && (luck = (player = (Player)entity).getAttributeValue(Attributes.LUCK)) > 0.0) {
                finalChance = Math.min(finalChance + luck * (Double)Config.LOOT_LUCK_MULTIPLIER.get(), 1.0);
            }
            if (randNumber <= finalChance) {
                int count = context.getRandom().nextInt(((Integer)Config.MAX_CLOVER_IN_LOOT.get()).intValue()) + 1;
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item, count));
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

