/*
 * Decompiled with CFR 0.152.
 */
package net.tarminarx.trxluckyclover.loot;

import com.mojang.serialization.MapCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tarminarx.trxluckyclover.loot.ModLootConditions;

public class ChestLootTableCondition
implements LootItemCondition {
    public static final ChestLootTableCondition INSTANCE = new ChestLootTableCondition();
    public static final MapCodec<ChestLootTableCondition> CODEC = MapCodec.unit(ChestLootTableCondition::new);

    private ChestLootTableCondition() {
    }

    public LootItemConditionType getType() {
        return ModLootConditions.IS_CHEST_LOOT.get();
    }

    public boolean test(LootContext context) {
        ResourceLocation tableId = context.getQueriedLootTableId();
        String path = tableId.getPath();
        String namespace = tableId.getNamespace();
        if (path.startsWith("chests/")) {
            return true;
        }
        if (namespace.equals("lootr")) {
            return true;
        }
        return path.contains("chest") || path.contains("treasure") || path.contains("loot");
    }
}

