/*
 * Decompiled with CFR 0.152.
 */
package net.kairost.torohealth.client.render;

import net.kairost.torohealth.ToroHealth;
import net.kairost.torohealth.client.render.TextureSubmittable;
import net.kairost.torohealth.client.util.EntityUtil;
import net.kairost.torohealth.config.ModConfig;
import net.kairost.torohealth.data.BarState;
import net.kairost.torohealth.data.BarStateAccessor;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class InWorldBarRenderer {
    private static final int DARK_GRAY = -8355712;
    private static final float SIZE = 0.025f;
    private static final int BAR_WIDTH = 40;
    private static final class_2960 IN_WORLD_BAR = class_2960.method_60655((String)"torohealth", (String)"in_world_bar");
    private static final class_1058 sprite = class_310.method_1551().method_72703().method_73025(class_10725.field_56389).method_4608(IN_WORLD_BAR);
    private static final TextureSubmittable submittable = new TextureSubmittable();

    public static void render(class_1297 entity, class_4184 camera, float tickDelta, int light, class_898 entityRenderManager) {
        if (!InWorldBarRenderer.shouldRender(entity, entityRenderManager)) {
            return;
        }
        class_243 vec3d = camera.method_71156();
        double x = class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317()) - vec3d.field_1352;
        double y = class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318()) - vec3d.field_1351;
        double z = class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321()) - vec3d.field_1350;
        float f = entity.method_17682() + 0.7f;
        Vector3f vector3f = new Vector3f(-20.0f, -5.0f, 0.0f).rotate((Quaternionfc)camera.method_23767()).mul(0.025f).add((float)x, (float)y + f, (float)z);
        InWorldBarRenderer.renderHealthBar((class_1309)entity, vector3f.x, vector3f.y, vector3f.z, new Quaternionf((Quaternionfc)camera.method_23767()), light, tickDelta);
    }

    private static void renderHealthBar(class_1309 entity, float x, float y, float z, Quaternionf quaternionf, int light, float tickDelta) {
        BarState state = ((BarStateAccessor)entity).torohealth$getBarState();
        EntityUtil.Relation relation = EntityUtil.getRelation((class_1297)entity);
        int color = relation.equals((Object)EntityUtil.Relation.FOE) ? ToroHealth.getConfig().barColor.foeColor : ToroHealth.getConfig().barColor.friendColor;
        int color2 = relation.equals((Object)EntityUtil.Relation.FOE) ? ToroHealth.getConfig().barColor.foeColorSecondary : ToroHealth.getConfig().barColor.friendColorSecondary;
        color |= 0xFF000000;
        color2 |= 0xFF000000;
        float percent = Math.min(state.health, entity.method_6063()) / entity.method_6063();
        float percent2 = Math.min(class_3532.method_16439((float)tickDelta, (float)state.lastHealthDisplay, (float)state.healthDisplay), entity.method_6063()) / entity.method_6063();
        int width = Math.min(class_3532.method_15386((float)(percent * 41.0f)), 40);
        int width2 = Math.min(class_3532.method_15386((float)(percent2 * 41.0f)), 40);
        Vector3f shift = new Vector3f(0.0f, 0.0f, 0.1f).rotate((Quaternionfc)quaternionf).mul(0.025f);
        if (40 > width && 40 > width2) {
            InWorldBarRenderer.renderBar(x, y, z, -8355712, 40, light, quaternionf);
        }
        if (width2 > width) {
            InWorldBarRenderer.renderBar(x + shift.x, y + shift.y, z + shift.z, color2, width2, light, quaternionf);
        }
        if (width > 0) {
            InWorldBarRenderer.renderBar(x + 2.0f * shift.x, y + 2.0f * shift.y, z + 2.0f * shift.z, color, width, light, quaternionf);
        }
    }

    private static void renderBar(float x, float y, float z, int color, int width, int light, Quaternionf rotation) {
        float u1 = sprite.method_4594();
        float u2 = class_3532.method_16439((float)((float)width / 40.0f), (float)sprite.method_4594(), (float)sprite.method_4577());
        float v1 = sprite.method_4593();
        float v2 = sprite.method_4575();
        submittable.render(class_3940.class_11941.field_62641, x, y, z, width, 5.0f, rotation.x, rotation.y, rotation.z, rotation.w, 0.025f, u1, u2, v1, v2, color, light);
    }

    private static boolean shouldRender(class_1297 entity, class_898 entityRenderManager) {
        if (ToroHealth.getConfig().inWorldBarOptions.inWorldBarVisibilityMode.equals((Object)ModConfig.InWorldBarVisibilityMode.NONE)) {
            return false;
        }
        if (ToroHealth.getConfig().inWorldBarOptions.inWorldBarVisibilityMode.equals((Object)ModConfig.InWorldBarVisibilityMode.WHEN_HOLDING_WEAPON) && !ToroHealth.isHoldingWeapon()) {
            return false;
        }
        if (!(entity instanceof class_1309)) {
            return false;
        }
        class_1309 livingEntity = (class_1309)entity;
        if (entityRenderManager.method_23168(entity) > (double)ToroHealth.getConfig().inWorldBarOptions.inWorldBarDistanceSquared) {
            return false;
        }
        if (ToroHealth.getConfig().inWorldBarOptions.onlyWhenHurt && livingEntity.method_6032() >= livingEntity.method_6063()) {
            return false;
        }
        if (ToroHealth.getConfig().inWorldBarOptions.onlyWhenLookingAt && ToroHealth.getTargetedEntity() != entity) {
            return false;
        }
        return EntityUtil.showHealthBar(entity, class_310.method_1551());
    }

    public static TextureSubmittable getSubmittable() {
        return submittable;
    }
}

