/*
 * Decompiled with CFR 0.152.
 */
package net.kairost.torohealth.client.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_11659;
import net.minecraft.class_11942;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_12075;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_3940;
import net.minecraft.class_4588;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class TextureSubmittable
implements class_11659.class_11947,
class_11942 {
    private static final int INITIAL_BUFFER_MAX_LENGTH = 1024;
    private static final int BUFFER_FLOAT_FIELDS = 14;
    private static final int BUFFER_INT_FIELDS = 2;
    private final Map<class_3940.class_11941, Vertices> bufferByType = new HashMap<class_3940.class_11941, Vertices>();
    private int textures;

    public void render(class_3940.class_11941 renderType, float x, float y, float z, float width, float height, float rotationX, float rotationY, float rotationZ, float rotationW, float size, float minU, float maxU, float minV, float maxV, int color, int brightness) {
        this.bufferByType.computeIfAbsent(renderType, renderTypex -> new Vertices()).vertex(x, y, z, width, height, rotationX, rotationY, rotationZ, rotationW, size, minU, maxU, minV, maxV, color, brightness);
        ++this.textures;
    }

    public void method_74316() {
        this.bufferByType.values().forEach(Vertices::reset);
        this.textures = 0;
    }

    @Nullable
    public class_11944.class_12041 method_74755(class_11977.class_12051 cache) {
        Object var13;
        int i = this.textures * 4;
        try (class_9799 bufferAllocator = class_9799.method_72201((int)(i * class_290.field_1584.getVertexSize()));){
            class_287 bufferBuilder = new class_287(bufferAllocator, VertexFormat.class_5596.field_27382, class_290.field_1584);
            HashMap<class_3940.class_11941, class_11944.class_12042> map = new HashMap<class_3940.class_11941, class_11944.class_12042>();
            int j = 0;
            for (Map.Entry<class_3940.class_11941, Vertices> entry : this.bufferByType.entrySet()) {
                entry.getValue().render((x, y, z, width, height, rotationX, rotationY, rotationZ, rotationW, size, minU, maxU, minV, maxV, color, brightness) -> this.drawFace((class_4588)bufferBuilder, x, y, z, width, height, rotationX, rotationY, rotationZ, rotationW, size, minU, maxU, minV, maxV, color, brightness));
                if (entry.getValue().nextVertexIndex() > 0) {
                    map.put(entry.getKey(), new class_11944.class_12042(j, entry.getValue().nextVertexIndex() * 6));
                }
                j += entry.getValue().nextVertexIndex() * 4;
            }
            class_9801 builtBuffer = bufferBuilder.method_60794();
            if (builtBuffer != null) {
                cache.method_74835(builtBuffer.method_60818());
                RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_68274(builtBuffer.method_60822().comp_751());
                GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f());
                class_11944.class_12041 class_120412 = new class_11944.class_12041(builtBuffer.method_60822().comp_751(), gpuBufferSlice, map);
                return class_120412;
            }
            var13 = null;
        }
        return var13;
    }

    public void method_74324(class_11944.class_12041 buffers, class_11977.class_12051 cache, RenderPass renderPass, class_1060 manager, boolean translucent) {
        RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        renderPass.setVertexBuffer(0, cache.method_74834());
        renderPass.setIndexBuffer(shapeIndexBuffer.method_68274(buffers.comp_4897()), shapeIndexBuffer.method_31924());
        renderPass.setUniform("DynamicTransforms", buffers.comp_4898());
        for (Map.Entry entry : buffers.comp_4899().entrySet()) {
            if (translucent != ((class_3940.class_11941)entry.getKey()).comp_4894()) continue;
            renderPass.setPipeline(((class_3940.class_11941)entry.getKey()).comp_4896());
            class_1044 abstractTexture = manager.method_4619(((class_3940.class_11941)entry.getKey()).comp_4895());
            renderPass.bindTexture("Sampler0", abstractTexture.method_71659(), abstractTexture.method_75484());
            renderPass.drawIndexed(((class_11944.class_12042)entry.getValue()).comp_4900(), 0, ((class_11944.class_12042)entry.getValue()).comp_4901(), 1);
        }
    }

    protected void drawFace(class_4588 vertexConsumer, float x, float y, float z, float width, float height, float rotationX, float rotationY, float rotationZ, float rotationW, float size, float minU, float maxU, float minV, float maxV, int color, int brightness) {
        Quaternionf quaternionf = new Quaternionf(rotationX, rotationY, rotationZ, rotationW);
        this.renderVertex(vertexConsumer, quaternionf, x, y, z, width, 0.0f, size, maxU, maxV, color, brightness);
        this.renderVertex(vertexConsumer, quaternionf, x, y, z, width, height, size, maxU, minV, color, brightness);
        this.renderVertex(vertexConsumer, quaternionf, x, y, z, 0.0f, height, size, minU, minV, color, brightness);
        this.renderVertex(vertexConsumer, quaternionf, x, y, z, 0.0f, 0.0f, size, minU, maxV, color, brightness);
    }

    private void renderVertex(class_4588 vertexConsumer, Quaternionf rotation, float x, float y, float z, float localX, float localY, float size, float maxU, float maxV, int color, int brightness) {
        Vector3f vector3f = new Vector3f(localX, localY, 0.0f).rotate((Quaternionfc)rotation).mul(size).add(x, y, z);
        vertexConsumer.method_22912(vector3f.x(), vector3f.y(), vector3f.z()).method_22913(maxU, maxV).method_39415(color).method_60803(brightness);
    }

    public void submit(class_11659 orderedRenderCommandQueue, class_12075 cameraRenderState) {
        if (this.textures > 0) {
            orderedRenderCommandQueue.method_74315((class_11659.class_11947)this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class Vertices {
        private int maxVertices = 1024;
        private float[] floatData = new float[14336];
        private int[] intData = new int[2048];
        private int nextVertexIndex;

        Vertices() {
        }

        public void vertex(float x, float y, float z, float width, float height, float rotationX, float rotationY, float rotationZ, float rotationW, float size, float minU, float maxU, float minV, float maxV, int color, int brightness) {
            if (this.nextVertexIndex >= this.maxVertices) {
                this.increaseCapacity();
            }
            int i = this.nextVertexIndex * 14;
            this.floatData[i++] = x;
            this.floatData[i++] = y;
            this.floatData[i++] = z;
            this.floatData[i++] = width;
            this.floatData[i++] = height;
            this.floatData[i++] = rotationX;
            this.floatData[i++] = rotationY;
            this.floatData[i++] = rotationZ;
            this.floatData[i++] = rotationW;
            this.floatData[i++] = size;
            this.floatData[i++] = minU;
            this.floatData[i++] = maxU;
            this.floatData[i++] = minV;
            this.floatData[i] = maxV;
            i = this.nextVertexIndex * 2;
            this.intData[i++] = color;
            this.intData[i] = brightness;
            ++this.nextVertexIndex;
        }

        public void render(Consumer vertexConsumer) {
            for (int i = 0; i < this.nextVertexIndex; ++i) {
                int j = i * 14;
                int k = i * 2;
                vertexConsumer.consume(this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j], this.intData[k++], this.intData[k]);
            }
        }

        public void reset() {
            this.nextVertexIndex = 0;
        }

        private void increaseCapacity() {
            this.maxVertices *= 2;
            this.floatData = Arrays.copyOf(this.floatData, this.maxVertices * 14);
            this.intData = Arrays.copyOf(this.intData, this.maxVertices * 2);
        }

        public int nextVertexIndex() {
            return this.nextVertexIndex;
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Consumer {
        public void consume(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, int var15, int var16);
    }
}

