/*
 * Decompiled with CFR 0.152.
 */
package net.kairost.torohealth.data;

import net.minecraft.class_1309;
import net.minecraft.class_3532;

public class BarState {
    private static final float HEALTH_DISPLAY_DELAY = 5.0f;
    private static final float HEALTH_CUMULATE_DELAY = 20.0f;
    public float health;
    public float lastHealth;
    public float healthDisplay;
    public float lastHealthDisplay;
    public int healthChangeLast;
    public int healthChangeCumulate;
    public float healthCumulateDelay;
    public float healthDisplayDelay;
    private float animationSpeed;

    private BarState(float health) {
        this.health = health;
        this.healthDisplay = health;
        this.lastHealthDisplay = health;
        this.healthChangeLast = 0;
        this.healthChangeCumulate = 0;
        this.lastHealth = health;
        this.healthCumulateDelay = 0.0f;
        this.animationSpeed = 0.0f;
    }

    public static BarState create(class_1309 entity) {
        float currentHealth = Math.min(entity.method_6032(), entity.method_6063());
        return new BarState(currentHealth);
    }

    public void tick() {
        this.incrementTimers();
        if (this.healthCumulateDelay <= 0.0f) {
            this.reset();
        }
        this.updateAnimations();
    }

    private void reset() {
        this.healthChangeLast = 0;
        this.healthChangeCumulate = 0;
    }

    private void incrementTimers() {
        if (this.healthCumulateDelay > 0.0f) {
            this.healthCumulateDelay -= 1.0f;
        }
        if (this.healthDisplayDelay > 0.0f) {
            this.healthDisplayDelay -= 1.0f;
        }
    }

    public void handleHealthChange() {
        this.healthChangeLast = class_3532.method_15386((float)this.health) - class_3532.method_15386((float)this.lastHealth);
        this.healthChangeCumulate += this.healthChangeLast;
        this.healthCumulateDelay = 20.0f;
        this.healthDisplay = Math.max(Math.max(this.lastHealth, this.healthDisplay), this.health);
        if (this.healthDisplay <= this.lastHealth) {
            this.healthDisplayDelay = 5.0f;
        }
        this.updateAnimationSpeed();
    }

    private void updateAnimationSpeed() {
        this.animationSpeed = (this.healthDisplay - this.health) / 10.0f;
    }

    private void updateAnimations() {
        this.lastHealthDisplay = this.healthDisplay;
        if (this.healthDisplayDelay <= 0.0f) {
            this.healthDisplay = Math.max(this.healthDisplay - this.animationSpeed, this.health);
        }
    }

    public void updateHealth(float health) {
        this.lastHealth = this.health;
        this.health = health;
    }
}

