/*
 * Decompiled with CFR 0.152.
 */
package net.kairost.torohealth.client.render;

import net.kairost.torohealth.ToroHealth;
import net.kairost.torohealth.client.util.EntityUtil;
import net.kairost.torohealth.config.ModConfig;
import net.kairost.torohealth.data.BarState;
import net.kairost.torohealth.data.BarStateAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_898;
import org.joml.Matrix4f;

public class InWorldBarRenderer {
    private static final int DARK_GRAY = 0x808080;
    private static final class_2960 TOROHEALTH_BARS_TEXTURES = new class_2960("torohealth:textures/gui/bars.png");

    public static void render(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, class_898 entityRenderDispatcher) {
        if (!InWorldBarRenderer.shouldRender(entity, entityRenderDispatcher)) {
            return;
        }
        matrices.method_22903();
        double x = class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317());
        double y = class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318());
        double z = class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321());
        matrices.method_22904(x - cameraX, y - cameraY, z - cameraZ);
        float f = entity.method_17682() + 0.7f;
        matrices.method_22904(0.0, (double)f, 0.0);
        matrices.method_22907(entityRenderDispatcher.method_24197());
        matrices.method_22905(-0.025f, -0.025f, 0.025f);
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23028((class_2960)TOROHEALTH_BARS_TEXTURES));
        InWorldBarRenderer.renderHealthBar(matrices, (class_1309)entity, -20.0f, 0.0f, light, buffer, tickDelta);
        matrices.method_22909();
    }

    private static void renderHealthBar(class_4587 matrices, class_1309 entity, float x, float y, int light, class_4588 buffer, float tickDelta) {
        BarState state = ((BarStateAccessor)entity).torohealth$getBarState();
        Matrix4f matrix = matrices.method_23760().method_23761();
        EntityUtil.Relation relation = EntityUtil.getRelation((class_1297)entity);
        int color = relation.equals((Object)EntityUtil.Relation.FOE) ? ToroHealth.getConfig().barColor.foeColor : ToroHealth.getConfig().barColor.friendColor;
        int color2 = relation.equals((Object)EntityUtil.Relation.FOE) ? ToroHealth.getConfig().barColor.foeColorSecondary : ToroHealth.getConfig().barColor.friendColorSecondary;
        float percent = Math.min(state.health, entity.method_6063()) / entity.method_6063();
        float percent2 = Math.min(class_3532.method_16439((float)tickDelta, (float)state.lastHealthDisplay, (float)state.healthDisplay), entity.method_6063()) / entity.method_6063();
        int width = class_3532.method_15386((float)(percent * 41.0f));
        int width2 = class_3532.method_15386((float)(percent2 * 41.0f));
        if (40 > width && 40 > width2) {
            InWorldBarRenderer.renderBar(matrix, x, y, 0.0f, 0x808080, 40, light, buffer);
        }
        if (width2 > width) {
            InWorldBarRenderer.renderBar(matrix, x, y, -0.1f, color2, width2, light, buffer);
        }
        if (width > 0) {
            InWorldBarRenderer.renderBar(matrix, x, y, -0.2f, color, width, light, buffer);
        }
    }

    private static void renderBar(Matrix4f matrix, float x0, float y0, float z, int color, int width, int light, class_4588 buffer) {
        float x1 = x0 + (float)width;
        float y1 = 5.0f + y0;
        float u0 = 0.0f;
        float u1 = 0.0f + (float)width / 256.0f;
        float v0 = 0.52734375f;
        float v1 = 0.546875f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        buffer.method_22918(matrix, x0, y1, z).method_22915(r, g, b, 1.0f).method_22913(u0, v1).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix, x1, y1, z).method_22915(r, g, b, 1.0f).method_22913(u1, v1).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix, x1, y0, z).method_22915(r, g, b, 1.0f).method_22913(u1, v0).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix, x0, y0, z).method_22915(r, g, b, 1.0f).method_22913(u0, v0).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    private static boolean shouldRender(class_1297 entity, class_898 entityRenderDispatcher) {
        if (ToroHealth.getConfig().inWorldBarOptions.inWorldBarVisibilityMode.equals((Object)ModConfig.InWorldBarVisibilityMode.NONE)) {
            return false;
        }
        if (ToroHealth.getConfig().inWorldBarOptions.inWorldBarVisibilityMode.equals((Object)ModConfig.InWorldBarVisibilityMode.WHEN_HOLDING_WEAPON) && !ToroHealth.isHoldingWeapon()) {
            return false;
        }
        if (!(entity instanceof class_1309)) {
            return false;
        }
        class_1309 livingEntity = (class_1309)entity;
        if (entityRenderDispatcher.method_23168(entity) > (double)ToroHealth.getConfig().inWorldBarOptions.inWorldBarDistanceSquared) {
            return false;
        }
        if (ToroHealth.getConfig().inWorldBarOptions.onlyWhenHurt && livingEntity.method_6032() >= livingEntity.method_6063()) {
            return false;
        }
        if (ToroHealth.getConfig().inWorldBarOptions.onlyWhenLookingAt && ToroHealth.getTargetedEntity() != entity) {
            return false;
        }
        return EntityUtil.showHealthBar(entity, class_310.method_1551());
    }
}

