/*
 * Decompiled with CFR 0.152.
 */
package net.kairost.torohealth.config;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class ColorJsonAdapter
extends TypeAdapter<Integer> {
    public void write(JsonWriter out, Integer value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(String.format("#%06X", value & 0xFFFFFF));
    }

    public Integer read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String s = in.nextString().trim();
        try {
            if (s.startsWith("#")) {
                return Integer.parseInt(s.substring(1), 16);
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            System.err.println("ToroHealth: Failed to parse color value '" + s + "', using default white (0xFFFFFF)");
            return 0xFFFFFF;
        }
    }
}

