/*
 * Decompiled with CFR 0.152.
 */
package net.kairost.torohealth.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.kairost.torohealth.ToroHealth;
import net.kairost.torohealth.client.util.EntityUtil;
import net.kairost.torohealth.config.ModConfig;
import net.kairost.torohealth.data.BarState;
import net.kairost.torohealth.data.BarStateAccessor;
import net.kairost.torohealth.mixin.accessor.WitherEntityAccessor;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1571;
import net.minecraft.class_1606;
import net.minecraft.class_1628;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ToroHealthHud {
    private static final class_2960 ICONS = new class_2960("textures/gui/icons.png");
    private static final class_2960 TOROHEALTH_BARS_TEXTURE = new class_2960("torohealth:textures/gui/bars.png");
    private static final class_2960 TOROHEALTH_FRAME_TEXTURE = new class_2960("torohealth:textures/gui/frame.png");
    private static final int DARK_GRAY = 0x808080;
    private static final int LIGHT_GRAY = 0xE0E0E0;
    private static final int FRAME_SIZE = 42;
    private static final float ENTITY_RENDER_HEIGHT = 32.0f;
    private static final float ENTITY_RENDER_WIDTH = 24.0f;
    private static final float ENTITY_RENDER_SCALE = 32.0f;
    private static final int INFO_Y_BASE = 2;
    private static final int INFO_X_BASE = 2;
    private static final int INFO_SPACING = 4;
    private static final int BAR_Y = 12;
    private static final int BAR_SIZE = 130;
    private static final int HEALTH_CHANGE_Y = 18;
    private final class_310 client;
    private class_1309 entity;
    private int age;
    private float entityX;
    private float entityY;
    private float entityScale;
    private boolean at_left;
    private boolean at_top;

    public ToroHealthHud(class_310 client) {
        this.client = client;
    }

    public void render(class_332 context, float tickDelta) {
        if (this.entity == null) {
            return;
        }
        if (this.entity.method_31481()) {
            return;
        }
        if (ToroHealth.getConfig().hudOptions.onlyWhenHurt && this.entity.method_6032() >= this.entity.method_6063()) {
            return;
        }
        context.method_51448().method_22903();
        float x = this.determineX();
        float y = this.determineY();
        int scale = ToroHealth.getConfig().hudOptions.hudScale;
        context.method_51448().method_46416(x, y, -90.0f);
        context.method_51448().method_22905((float)scale, (float)scale, (float)scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ToroHealth.getConfig().hudOptions.showEntity) {
            this.renderFrame(context);
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)((this.at_left ? 1 : -1) * 44), (float)((this.at_top ? 1 : -1) * (2 + (ToroHealth.getConfig().hudOptions.frameStyle.equals((Object)ModConfig.FrameStyle.HEAVY) ? 2 : 0))), 0.0f);
        }
        this.renderInfo(context, tickDelta);
        if (ToroHealth.getConfig().hudOptions.showEntity) {
            context.method_51448().method_22909();
            ToroHealthHud.drawEntity(context, this.entityX + (float)(this.at_left ? 0 : -42), this.entityY + (float)(this.at_top ? 0 : -42), this.entityScale, (this.at_left ? 1 : -1) * -80, -20.0f, this.entity, tickDelta);
        }
        context.method_51448().method_22909();
    }

    private float determineX() {
        float x = ToroHealth.getConfig().hudOptions.hudXPosition;
        float wScreen = this.client.method_22683().method_4486();
        return switch (ToroHealth.getConfig().hudOptions.anchorPoint) {
            default -> throw new IncompatibleClassChangeError();
            case ModConfig.AnchorPoint.BOTTOM_LEFT, ModConfig.AnchorPoint.TOP_LEFT -> {
                this.at_left = true;
                yield x;
            }
            case ModConfig.AnchorPoint.BOTTOM_RIGHT, ModConfig.AnchorPoint.TOP_RIGHT -> {
                this.at_left = false;
                yield wScreen + x;
            }
        };
    }

    private float determineY() {
        float y = ToroHealth.getConfig().hudOptions.hudYPosition;
        float hScreen = this.client.method_22683().method_4502();
        return switch (ToroHealth.getConfig().hudOptions.anchorPoint) {
            default -> throw new IncompatibleClassChangeError();
            case ModConfig.AnchorPoint.TOP_LEFT, ModConfig.AnchorPoint.TOP_RIGHT -> {
                this.at_top = true;
                yield y;
            }
            case ModConfig.AnchorPoint.BOTTOM_LEFT, ModConfig.AnchorPoint.BOTTOM_RIGHT -> {
                this.at_top = false;
                yield hScreen + y;
            }
        };
    }

    public void tick() {
        if (this.entity != null) {
            this.setEntityRenderPos();
            ++this.age;
        }
    }

    public void setEntity(class_1309 entity) {
        if (entity != null) {
            this.age = 0;
            if (entity != this.entity) {
                this.setEntityWork(entity);
            }
        }
        if (entity == null && this.age > ToroHealth.getConfig().hudOptions.hudHideDelay) {
            this.setEntityWork(null);
        }
    }

    private void setEntityWork(class_1309 entity) {
        this.entity = entity;
        if (entity != null) {
            if (entity instanceof class_1510) {
                this.entityScale = 64.0f / entity.method_17682();
            } else {
                float scale = this.entity.method_17825();
                float height = this.entity.method_17682() / scale;
                float width = this.entity.method_17681() / scale;
                this.entityScale = Math.min(32.0f / height, 24.0f / width);
                if (this.entityScale > 32.0f) {
                    this.entityScale = 32.0f;
                } else if (!(this.entityScale > 16.0f)) {
                    this.entityScale = (double)this.entityScale > 12.8 ? 16.0f : 5.0f * this.entityScale / 4.0f;
                }
            }
            this.setEntityRenderPos();
        } else {
            this.entityScale = 0.0f;
            this.entityX = 0.0f;
            this.entityY = 0.0f;
        }
    }

    private void setEntityRenderPos() {
        assert (this.entity != null);
        if (this.entityX == 0.0f) {
            this.entityX = 21.0f;
        }
        if (this.entityY == 0.0f) {
            this.entityY = 37.0f;
        }
        if (this.entity instanceof class_1571) {
            this.entityY = 21.0f + this.entity.method_17682() * this.entityScale / 4.0f;
        } else if (this.entity instanceof class_1510) {
            this.entityY = 21.0f + this.entity.method_17682() * this.entityScale / 4.0f;
        } else {
            class_1309 class_13092 = this.entity;
            if (class_13092 instanceof class_1606) {
                class_1606 shulker = (class_1606)class_13092;
                switch (shulker.method_7119()) {
                    case field_11033: {
                        this.entityY = 37.0f;
                        break;
                    }
                    case field_11036: {
                        this.entityY = 5.0f + this.entity.method_17682() * this.entityScale;
                        break;
                    }
                    case field_11043: 
                    case field_11035: 
                    case field_11034: 
                    case field_11039: {
                        this.entityY = 21.0f + this.entity.method_17682() * this.entityScale / 2.0f;
                    }
                }
            } else {
                class_1646 villager;
                class_13092 = this.entity;
                if (class_13092 instanceof class_1646 && (villager = (class_1646)class_13092).method_6113()) {
                    this.entityY = 21.0f + this.entity.method_17682() * this.entityScale / 2.0f;
                } else {
                    class_1657 player;
                    class_13092 = this.entity;
                    if (class_13092 instanceof class_1657 && (player = (class_1657)class_13092).method_6113()) {
                        this.entityY = 21.0f + this.entity.method_17682() * this.entityScale / 2.0f;
                    } else {
                        class_1420 bat;
                        class_13092 = this.entity;
                        if (class_13092 instanceof class_1420 && !(bat = (class_1420)class_13092).method_6450()) {
                            this.entityY = 5.0f + this.entity.method_17682() * this.entityScale;
                        } else {
                            class_1628 spider;
                            class_13092 = this.entity;
                            if (class_13092 instanceof class_1628 && (spider = (class_1628)class_13092).method_6101()) {
                                this.entityY = 21.0f + this.entity.method_17682() * this.entityScale / 2.0f;
                            } else if (this.entity.method_5765() || EntityUtil.isFloating(this.entity) || this.entity.method_6059(class_1294.field_5902)) {
                                this.entityY = 21.0f + this.entity.method_17682() * this.entityScale / 2.0f;
                            } else if (this.entity.method_24828()) {
                                this.entityY = 37.0f;
                            }
                        }
                    }
                }
            }
        }
    }

    private void renderFrame(class_332 context) {
        boolean light_style = ToroHealth.getConfig().hudOptions.frameStyle.equals((Object)ModConfig.FrameStyle.LIGHT);
        int h = 42;
        int w = light_style ? 42 : 179;
        int x = this.at_left ? 0 : -w;
        int y = this.at_top ? 0 : -h;
        int u = light_style ? 0 : 42;
        int v = (this.at_top ? 0 : 42) + (this.at_left ? 0 : 84);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)TOROHEALTH_FRAME_TEXTURE);
        context.method_25302(TOROHEALTH_FRAME_TEXTURE, x, y, u, v, w, h);
        RenderSystem.disableBlend();
    }

    private void renderInfo(class_332 context, float tickDelta) {
        int healthTextY;
        this.renderHealthBar(context, this.entity, this.at_left ? 0 : -130, this.at_top ? 12 : -17, tickDelta);
        int x_pos_scalar = this.at_left ? 1 : -1;
        int y_pos_scalar = this.at_top ? 1 : -1;
        int xOffset = x_pos_scalar * 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String name = this.entity.method_5476().getString();
        context.method_25303(this.client.field_1772, name, xOffset + (this.at_left ? 0 : -this.client.field_1772.method_1727(name)), this.at_top ? 1 : -8, 0xFFFFFF);
        xOffset += x_pos_scalar * (this.client.field_1772.method_1727(name) + 4);
        int healthMax = class_3532.method_15386((float)this.entity.method_6063());
        int healthCurrent = class_3532.method_15340((int)class_3532.method_15386((float)this.entity.method_6032()), (int)0, (int)healthMax);
        String healthText = healthCurrent + "/" + healthMax;
        int n = healthTextY = this.at_top ? 1 : -8;
        if (this.at_left) {
            this.renderHeartIcon(context, xOffset, healthTextY - 1);
            context.method_25303(this.client.field_1772, healthText, xOffset += 10, healthTextY, 0xFFFFFF);
            xOffset += this.client.field_1772.method_1727(healthText) + 4;
        } else {
            context.method_25303(this.client.field_1772, healthText, xOffset - this.client.field_1772.method_1727(healthText), healthTextY, 0xFFFFFF);
            this.renderHeartIcon(context, (xOffset -= this.client.field_1772.method_1727(healthText) + 1) - 9, healthTextY - 1);
            xOffset -= 13;
        }
        int armor = this.entity.method_6096();
        if (armor > 0) {
            int armorTextY;
            String armorText = Integer.toString(armor);
            int n2 = armorTextY = this.at_top ? 1 : -8;
            if (this.at_left) {
                this.renderArmorIcon(context, xOffset, armorTextY - 1);
                context.method_25303(this.client.field_1772, armorText, xOffset += 10, armorTextY, 0xFFFFFF);
            } else {
                context.method_25303(this.client.field_1772, armorText, xOffset - this.client.field_1772.method_1727(armorText), armorTextY, 0xFFFFFF);
                this.renderArmorIcon(context, (xOffset -= this.client.field_1772.method_1727(Integer.toString(this.entity.method_6096())) + 1) - 9, armorTextY - 1);
            }
        }
        this.renderHealthChangeText(context, this.entity, (this.at_left ? 1 : -1) * 130, y_pos_scalar * 18);
    }

    private void renderHeartIcon(class_332 context, int x, int y) {
        RenderSystem.enableBlend();
        context.method_25302(ICONS, x, y, 16, 0, 9, 9);
        context.method_25302(ICONS, x, y, 52, 0, 9, 9);
        RenderSystem.disableBlend();
    }

    private void renderArmorIcon(class_332 context, int x, int y) {
        RenderSystem.enableBlend();
        context.method_25302(ICONS, x, y, 34, 9, 9, 9);
        RenderSystem.disableBlend();
    }

    private void renderHealthChangeText(class_332 context, class_1309 entity, int x, int y) {
        int color;
        BarState state = ((BarStateAccessor)entity).torohealth$getBarState();
        if (state == null) {
            return;
        }
        int healthChange = switch (ToroHealth.getConfig().hudOptions.healthChangeType) {
            case ModConfig.HealthChangeType.LAST -> state.healthChangeLast;
            case ModConfig.HealthChangeType.CUMULATIVE -> state.healthChangeCumulate;
            default -> 0;
        };
        int n = color = healthChange > 0 ? ToroHealth.getConfig().particleOptions.healColor : ToroHealth.getConfig().particleOptions.damageColor;
        if (healthChange != 0) {
            String text = Integer.toString(Math.abs(healthChange));
            context.method_25303(this.client.field_1772, text, x + (this.at_left ? -this.client.field_1772.method_1727(text) : 2), this.at_top ? y : y - 8, color);
        }
    }

    private void renderHealthBar(class_332 context, class_1309 entity, int x, int y, float tickDelta) {
        BarState state = ((BarStateAccessor)entity).torohealth$getBarState();
        if (state == null) {
            return;
        }
        EntityUtil.Relation relation = EntityUtil.getRelation((class_1297)entity);
        int color = relation.equals((Object)EntityUtil.Relation.FOE) ? ToroHealth.getConfig().barColor.foeColor : ToroHealth.getConfig().barColor.friendColor;
        int color2 = relation.equals((Object)EntityUtil.Relation.FOE) ? ToroHealth.getConfig().barColor.foeColorSecondary : ToroHealth.getConfig().barColor.friendColorSecondary;
        float percent = Math.min(state.health, entity.method_6063()) / entity.method_6063();
        float percent2 = Math.min(class_3532.method_16439((float)tickDelta, (float)state.lastHealthDisplay, (float)state.healthDisplay), entity.method_6063()) / entity.method_6063();
        int width = class_3532.method_15386((float)(percent * 131.0f));
        int width2 = class_3532.method_15386((float)(percent2 * 131.0f));
        if (130 > width && 130 > width2) {
            this.renderBar(context, x, y, 130, 0x808080);
        }
        if (width2 > width) {
            this.renderBar(context, x, y, width2, color2);
        }
        if (width > 0) {
            this.renderBar(context, x, y, width, color);
        }
    }

    private void renderBar(class_332 context, int x, int y, int width, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int shift = this.at_left ? 0 : 130 - width;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.enableBlend();
        context.method_25302(TOROHEALTH_BARS_TEXTURE, x + shift, y, shift, 65, width, 5);
        RenderSystem.disableBlend();
    }

    public static void drawEntity(class_332 context, float x, float y, float size, float mouseX, float mouseY, class_1309 entity, float tickDelta) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float i = entity.field_6283;
        float j = entity.field_6220;
        float k = entity.field_6241;
        float l = entity.field_6259;
        entity.field_6283 = 180.0f + f * 20.0f;
        entity.field_6220 = 180.0f + f * 20.0f;
        entity.field_6241 = 180.0f + f * 20.0f + k - i;
        entity.field_6259 = 180.0f + f * 20.0f + l - j;
        if (entity instanceof class_1510) {
            class_1510 dragon = (class_1510)entity;
            class_1511 endCrystal = dragon.field_7024;
            dragon.field_7024 = null;
            ToroHealthHud.drawEntity(context, x, y, size, quaternionf, quaternionf2, entity, tickDelta);
            dragon.field_7024 = endCrystal;
        } else if (entity instanceof class_1528) {
            class_1528 wither = (class_1528)entity;
            WitherEntityAccessor witherEntityAccessor = (WitherEntityAccessor)wither;
            float[] sideHeadYaws = witherEntityAccessor.torohealth$getSideHeadYaws();
            float[] prevSideHeadYaws = witherEntityAccessor.torohealth$getPrevSideHeadYaws();
            float[] m = (float[])sideHeadYaws.clone();
            float[] n = (float[])prevSideHeadYaws.clone();
            sideHeadYaws[0] = 180.0f + f * 20.0f + sideHeadYaws[0] - i;
            sideHeadYaws[1] = 180.0f + f * 20.0f + sideHeadYaws[1] - i;
            prevSideHeadYaws[0] = 180.0f + f * 20.0f + prevSideHeadYaws[0] - i;
            prevSideHeadYaws[1] = 180.0f + f * 20.0f + prevSideHeadYaws[1] - i;
            ToroHealthHud.drawEntity(context, x, y, size, quaternionf, quaternionf2, entity, tickDelta);
            System.arraycopy(m, 0, sideHeadYaws, 0, m.length);
            System.arraycopy(n, 0, prevSideHeadYaws, 0, n.length);
        } else {
            ToroHealthHud.drawEntity(context, x, y, size, quaternionf, quaternionf2, entity, tickDelta);
        }
        entity.field_6283 = i;
        entity.field_6220 = j;
        entity.field_6241 = k;
        entity.field_6259 = l;
    }

    public static void drawEntity(class_332 context, float x, float y, float size, Quaternionf quaternionf, Quaternionf quaternionf2, class_1309 entity, float tickDelta) {
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)x, (double)y, 50.0);
        context.method_51448().method_34425(new Matrix4f().scaling(size, size, -size));
        context.method_51448().method_22907(quaternionf);
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            entityRenderDispatcher.method_24196(quaternionf2);
        }
        entityRenderDispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, tickDelta, context.method_51448(), (class_4597)context.method_51450(), 0xF000F0));
        context.method_51452();
        entityRenderDispatcher.method_3948(true);
        context.method_51448().method_22909();
        class_308.method_24211();
    }
}

