/*
 * Decompiled with CFR 0.152.
 */
package net.kairost.torohealth.config;

import com.google.gson.annotations.JsonAdapter;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.kairost.torohealth.config.ColorJsonAdapter;

@Config(name="torohealth")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static ModConfig INSTANCE;
    public boolean enabled = true;
    @ConfigEntry.Gui.CollapsibleObject
    public HudOptions hudOptions = new HudOptions();
    @ConfigEntry.Gui.CollapsibleObject
    public ParticleOptions particleOptions = new ParticleOptions();
    @ConfigEntry.Gui.CollapsibleObject
    public InWorldBarOptions inWorldBarOptions = new InWorldBarOptions();
    @ConfigEntry.Gui.CollapsibleObject
    public BarColor barColor = new BarColor();

    public static void init() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        INSTANCE = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        INSTANCE.postLoad();
    }

    public void postLoad() {
        this.particleOptions.particleDistanceSquared = this.particleOptions.particleDistance * this.particleOptions.particleDistance;
        this.inWorldBarOptions.inWorldBarDistanceSquared = this.inWorldBarOptions.inWorldBarDistance * this.inWorldBarOptions.inWorldBarDistance;
    }

    public static class HudOptions {
        @ConfigEntry.Gui.Tooltip
        public boolean showHUD = true;
        @ConfigEntry.Gui.Tooltip
        public boolean showEntity = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public FrameStyle frameStyle = FrameStyle.LIGHT;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public HealthChangeType healthChangeType = HealthChangeType.LAST;
        @ConfigEntry.Gui.Tooltip
        public boolean onlyWhenHurt = false;
        @ConfigEntry.Gui.Tooltip
        public float hudDistance = 128.0f;
        @ConfigEntry.Gui.Tooltip
        public int hudHideDelay = 20;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public AnchorPoint anchorPoint = AnchorPoint.TOP_LEFT;
        @ConfigEntry.Gui.Tooltip
        public int hudXPosition = 2;
        @ConfigEntry.Gui.Tooltip
        public int hudYPosition = 2;
        @ConfigEntry.Gui.Tooltip
        public int hudScale = 1;
    }

    public static class ParticleOptions {
        @ConfigEntry.Gui.Tooltip
        public boolean showParticle = true;
        @ConfigEntry.Gui.Tooltip
        public float particleDistance = 64.0f;
        @ConfigEntry.Gui.Excluded
        public transient float particleDistanceSquared = 0.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        @JsonAdapter(value=ColorJsonAdapter.class)
        public int damageColor = 0xFF0000;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        @JsonAdapter(value=ColorJsonAdapter.class)
        public int healColor = 65280;
    }

    public static class InWorldBarOptions {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public InWorldBarVisibilityMode inWorldBarVisibilityMode = InWorldBarVisibilityMode.NONE;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public InWorldBarLightMode inWorldBarLightMode = InWorldBarLightMode.ENTITY_LIGHT;
        @ConfigEntry.Gui.Tooltip
        public boolean onlyWhenLookingAt = false;
        @ConfigEntry.Gui.Tooltip
        public boolean onlyWhenHurt = false;
        @ConfigEntry.Gui.Tooltip
        public float inWorldBarDistance = 64.0f;
        @ConfigEntry.Gui.Excluded
        public transient float inWorldBarDistanceSquared = 0.0f;
    }

    public static class BarColor {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        @JsonAdapter(value=ColorJsonAdapter.class)
        public int friendColor = 65280;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        @JsonAdapter(value=ColorJsonAdapter.class)
        public int friendColorSecondary = 32768;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        @JsonAdapter(value=ColorJsonAdapter.class)
        public int foeColor = 0xFF0000;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        @JsonAdapter(value=ColorJsonAdapter.class)
        public int foeColorSecondary = 0x800000;
    }

    public static enum HealthChangeType {
        NONE,
        LAST,
        CUMULATIVE;

    }

    public static enum InWorldBarLightMode {
        ENTITY_LIGHT,
        FULL_BRIGHT;

    }

    public static enum InWorldBarVisibilityMode {
        NONE,
        WHEN_HOLDING_WEAPON,
        ALWAYS;

    }

    public static enum FrameStyle {
        LIGHT,
        HEAVY;

    }

    public static enum AnchorPoint {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

