/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend;

import de.ambertation.wunderlib.network.ClientBoundPacketHandler;
import java.util.ServiceLoader;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.api.BetterEndPlugin;
import org.betterx.betterend.commands.CommandRegistry;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.effects.EndPotions;
import org.betterx.betterend.effects.EndStatusEffects;
import org.betterx.betterend.integration.Integrations;
import org.betterx.betterend.integration.byg.features.BYGFeatures;
import org.betterx.betterend.network.RitualUpdate;
import org.betterx.betterend.recipe.builders.InfusionRecipe;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndEnchantments;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndMenuTypes;
import org.betterx.betterend.registry.EndNumericProviders;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.tab.CreativeTabs;
import org.betterx.betterend.util.BonemealPlants;
import org.betterx.betterend.util.LootTableUtil;
import org.betterx.betterend.world.generator.EndLandBiomeDecider;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.datagen.betterend.BetterEndDatagen;
import org.betterx.wover.block.api.BlockRegistry;
import org.betterx.wover.core.api.Logger;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.generator.api.biomesource.end.BiomeDecider;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.state.api.WorldConfig;

@Mod(value="betterend")
public class BetterEnd {
    public static final String MOD_ID = "betterend";
    public static final ModCore C = ModCore.create((String)"betterend");
    public static final Logger LOGGER = BetterEnd.C.LOG;
    public static final ModCore BYG = ModCore.create((String)"byg");
    public static final ModCore NOURISH = ModCore.create((String)"nourish");
    public static final ModCore FLAMBOYANT = ModCore.create((String)"flamboyant");
    public static final ModCore PATCHOULI = ModCore.create((String)"patchouli");
    public static final ModCore HYDROGEN = ModCore.create((String)"hydrogen");
    public static final ModCore TRINKETS_CORE = ModCore.create((String)"trinkets");
    public static final boolean ENABLE_GUIDEBOOK = false;
    public static final ResourceLocation BYG_ADDITIONS_PACK = C.addDatapack(BYG);
    public static final ResourceLocation NOURISH_ADDITIONS_PACK = C.addDatapack(NOURISH);
    public static final ResourceLocation FLAMBOYANT_ADDITIONS_PACK = C.addDatapack(FLAMBOYANT);
    public static final ResourceLocation PATCHOULI_ADDITIONS_PACK = null;
    private static boolean bonemealInitialized = false;

    public BetterEnd(IEventBus modBus) {
        C.registerDatapackListener(modBus);
        modBus.addListener(EndSounds::register);
        modBus.addListener(RegisterEvent.class, EndEntities::onRegister);
        modBus.addListener(EntityAttributeCreationEvent.class, EndEntities::onRegisterAttributes);
        modBus.addListener(RegisterEvent.class, EndParticles::onRegister);
        modBus.addListener(RegisterEvent.class, EndPoiTypes::onRegister);
        modBus.addListener(RegisterEvent.class, this::registerFeatures);
        modBus.addListener(RegisterEvent.class, EndMenuTypes::onRegister);
        modBus.addListener(RegisterEvent.class, EndBlockEntities::register);
        modBus.addListener(RegisterEvent.class, this::ensureBlocksLoaded);
        modBus.addListener(RegisterEvent.class, this::ensureItemsLoaded);
        modBus.addListener(RegisterEvent.class, EndEnchantments::onRegister);
        modBus.addListener(RegisterEvent.class, EndStatusEffects::onRegister);
        modBus.addListener(RegisterEvent.class, EndPotions::onRegister);
        modBus.addListener(RegisterEvent.class, BECriteria::onRegister);
        modBus.addListener(RegisterEvent.class, CreativeTabs::onRegister);
        if (BYG.isLoaded()) {
            modBus.addListener(RegisterEvent.class, BYGFeatures::onRegister);
        }
        EndBlocks.ensureRegistered();
        BlockRegistry.hook((IEventBus)modBus);
        ItemRegistry.hook((IEventBus)modBus);
        if (ModCore.isDatagen()) {
            BetterEndDatagen datagen = new BetterEndDatagen();
            modBus.addListener(arg_0 -> ((BetterEndDatagen)datagen).onGatherData(arg_0));
        }
        this.initialize();
    }

    private void initialize() {
        WorldConfig.registerMod((ModCore)C);
        EndNumericProviders.register();
        EndPortals.loadPortals();
        EndMenuTypes.ensureStaticallyLoaded();
        EndBiomes.register();
        EndTags.register();
        EndPotions.register();
        InfusionRecipe.register();
        EndStructures.register();
        GeneratorOptions.init();
        LootTableUtil.init();
        CommandRegistry.register();
        EndParticles.ensureStaticallyLoadedServerside();
        ServiceLoader.load(BetterEndPlugin.class).forEach(BetterEndPlugin::register);
        Integrations.init();
        Configs.saveConfigs();
        CreativeTabs.register();
        if (GeneratorOptions.useNewGenerator()) {
            BiomeDecider.registerHighPriorityDecider((ResourceLocation)C.mk("end_land"), (BiomeDecider)new EndLandBiomeDecider());
        }
        ClientBoundPacketHandler.register((ResourceLocation)RitualUpdate.CHANNEL, RitualUpdate.Payload::new);
    }

    private void ensureBlocksLoaded(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.BLOCK)) {
            try {
                Class.forName("org.betterx.betterend.registry.EndBlocks");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!bonemealInitialized) {
                BonemealPlants.init();
                bonemealInitialized = true;
            }
        }
    }

    private void ensureItemsLoaded(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            try {
                Class.forName("org.betterx.betterend.registry.EndItems");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            EndItems.ensureStaticallyLoaded();
        }
    }

    private void registerFeatures(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.FEATURE)) {
            EndFeatures.onRegister(event);
        }
    }
}

