/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.blocks.entities.InfusionPedestalEntity;
import org.betterx.betterend.client.models.EndModels;
import org.betterx.betterend.rituals.InfusionRitual;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfusionPedestal
extends PedestalBlock
implements BehaviourStone,
BlockModelProvider {
    private static final VoxelShape SHAPE_DEFAULT;
    private static final VoxelShape SHAPE_PEDESTAL_TOP;
    private static final Map<EndBlockProperties.PedestalState, ModelTemplate> PEDESTAL_MODELS;

    public InfusionPedestal() {
        super(Blocks.OBSIDIAN);
        this.height = 1.08f;
    }

    @Override
    public void checkRitual(Level world, Player player, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof InfusionPedestalEntity) {
            InfusionPedestalEntity pedestal = (InfusionPedestalEntity)blockEntity;
            if (pedestal.hasRitual()) {
                InfusionRitual ritual = pedestal.getRitual();
                if (!ritual.isValid()) {
                    ritual.configure();
                }
                pedestal.getRitual().checkRecipe();
            } else {
                InfusionRitual ritual = pedestal.linkRitual(pedestal, world, pos);
                ritual.checkRecipe();
            }
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new InfusionPedestalEntity(blockPos, blockState);
    }

    @Override
    public boolean hasUniqueEntity() {
        return true;
    }

    @Override
    @Deprecated
    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.is((Block)this)) {
            return switch ((EndBlockProperties.PedestalState)((Object)state.getValue((Property)STATE))) {
                case EndBlockProperties.PedestalState.PEDESTAL_TOP -> SHAPE_PEDESTAL_TOP;
                case EndBlockProperties.PedestalState.DEFAULT -> SHAPE_DEFAULT;
                default -> super.getShape(state, world, pos, context);
            };
        }
        return super.getShape(state, world, pos, context);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return InfusionPedestalEntity::tickEntity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected TextureMapping createTextureMapping() {
        ResourceLocation parentTexture = TextureMapping.getBlockTexture((Block)this);
        return new TextureMapping().put(TextureSlot.TOP, parentTexture.withSuffix("_top")).put(TextureSlot.BOTTOM, parentTexture.withSuffix("_base")).put(EndModels.BASE, parentTexture.withSuffix("_base")).put(EndModels.PILLAR, parentTexture.withSuffix("_pillar"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        InfusionPedestal.provideBlockModel(generator, this.createTextureMapping(), (Block)this, PEDESTAL_MODELS);
    }

    static {
        PEDESTAL_MODELS = Map.of(EndBlockProperties.PedestalState.DEFAULT, EndModels.INFUSION_PEDESTAL_DEFAULT, EndBlockProperties.PedestalState.PEDESTAL_TOP, EndModels.INFUSION_PEDESTAL_TOP, EndBlockProperties.PedestalState.COLUMN_TOP, EndModels.PEDESTAL_COLUMN_TOP, EndBlockProperties.PedestalState.COLUMN, EndModels.PEDESTAL_COLUMN, EndBlockProperties.PedestalState.BOTTOM, EndModels.PEDESTAL_BOTTOM, EndBlockProperties.PedestalState.PILLAR, EndModels.PEDESTAL_PILLAR);
        VoxelShape basinUp = Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
        VoxelShape basinDown = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape pedestalTop = Block.box((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
        VoxelShape pedestalDefault = Block.box((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
        VoxelShape pillar = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
        VoxelShape pillarDefault = Block.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
        VoxelShape eyeDefault = Block.box((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape eyeTop = Block.box((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape basin = Shapes.or((VoxelShape)basinDown, (VoxelShape)basinUp);
        SHAPE_DEFAULT = Shapes.or((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{pillarDefault, pedestalDefault, eyeDefault});
        SHAPE_PEDESTAL_TOP = Shapes.or((VoxelShape)pillar, (VoxelShape[])new VoxelShape[]{pedestalTop, eyeTop});
    }
}

