/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.basis;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourShearablePlant;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.NotNull;

public class FurBlock
extends BaseAttachedBlock
implements RenderLayerProvider,
BehaviourShearablePlant,
BlockTagProvider,
BlockLootProvider,
BlockModelProvider {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);
    private final Block drop;
    private final int dropChance;

    public FurBlock(MapColor color, Block drop, int light, int dropChance, boolean wet) {
        super(BehaviourBuilders.createPlant((MapColor)color).replaceable().lightLevel(bs -> light).ignitedByLava().sound(wet ? SoundType.WET_GRASS : SoundType.GRASS));
        this.drop = drop;
        this.dropChance = dropChance;
    }

    public FurBlock(MapColor color, Block drop, int dropChance) {
        this(color, drop, 0, dropChance, false);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.getValue((Property)FACING));
    }

    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        float[] LEAVES_SAPLING_CHANCES = new float[]{0.8f * (float)this.dropChance, this.dropChance, 1.333f * (float)this.dropChance, 1.666f * (float)this.dropChance};
        return provider.dropLeaves((Block)this, this.drop, LEAVES_SAPLING_CHANCES);
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{BlockTags.LEAVES});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createCubeModel((Block)this);
        generator.createFlatItem((Block)this);
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0));
        BOUNDING_SHAPES.put(Direction.DOWN, Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0));
    }
}

