/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.betterx.betterend.BetterEnd;
import org.joml.Quaternionf;

public class EndCrystalRenderer {
    private static final ResourceLocation CRYSTAL_TEXTURE = BetterEnd.C.mk("textures/entity/end_crystal/end_crystal.png");
    private static final ResourceLocation CRYSTAL_BEAM_TEXTURE = BetterEnd.C.mk("textures/entity/end_crystal/end_crystal_beam.png");
    private static final RenderType END_CRYSTAL = RenderType.entityCutoutNoCull((ResourceLocation)CRYSTAL_TEXTURE);
    private static final ModelPart CORE;
    private static final ModelPart FRAME;
    private static final int AGE_CYCLE = 240;
    private static final float SINE_45_DEGREES;
    private static final Quaternionf ROTATOR;

    public static void render(int age, int maxAge, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider, int light) {
        float k = 240.0f / (float)maxAge;
        float rotation = ((float)age * k + tickDelta) * 3.0f;
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(END_CRYSTAL);
        matrices.pushPose();
        matrices.scale(0.8f, 0.8f, 0.8f);
        matrices.translate(0.0, -0.5, 0.0);
        matrices.mulPose(Axis.YP.rotationDegrees(rotation));
        matrices.translate(0.0, (double)0.8f, 0.0);
        matrices.mulPose(ROTATOR);
        FRAME.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        matrices.scale(0.875f, 0.875f, 0.875f);
        matrices.mulPose(ROTATOR);
        matrices.mulPose(Axis.YP.rotationDegrees(rotation));
        FRAME.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        matrices.scale(0.875f, 0.875f, 0.875f);
        matrices.mulPose(ROTATOR);
        matrices.mulPose(Axis.YP.rotationDegrees(rotation));
        CORE.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("FRAME", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("CORE", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)32);
    }

    static {
        RenderType.entitySmoothCutout((ResourceLocation)CRYSTAL_BEAM_TEXTURE);
        SINE_45_DEGREES = (float)Math.sin(0.7853981633974483);
        ModelPart root = EndCrystalRenderer.getTexturedModelData().bakeRoot();
        FRAME = root.getChild("FRAME");
        CORE = root.getChild("CORE");
        ROTATOR = new Quaternionf().setAngleAxis(1.0471976f, SINE_45_DEGREES, 0.0f, SINE_45_DEGREES);
    }
}

