/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.wover.poi.api.WoverPoiType;
import org.betterx.wover.state.api.WorldState;
import org.joml.Vector3d;

public class CommandRegistry {
    private static int biomeIndex = 0;
    private static final int MAX_SEARCH_RADIUS = 12800;
    private static final int SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int SAMPLE_RESOLUTION_VERTICAL = 64;
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> Component.literal((String)("The next biome (" + String.valueOf(object) + ") was not found.")));

    public static void register() {
        NeoForge.EVENT_BUS.addListener(CommandRegistry::onRegisterCommands);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandRegistry.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"be").requires(source -> source.hasPermission(4))).then(((LiteralArgumentBuilder)Commands.literal((String)"locate_portal").requires(source -> source.hasPermission(4))).executes(ctx -> CommandRegistry.find_poi((CommandContext<CommandSourceStack>)ctx, EndPoiTypes.ETERNAL_PORTAL)))).then(((LiteralArgumentBuilder)Commands.literal((String)"locate_portal_frame").requires(source -> source.hasPermission(4))).executes(ctx -> CommandRegistry.find_poi((CommandContext<CommandSourceStack>)ctx, EndPoiTypes.ETERNAL_PORTAL_FRAME)))).then(((LiteralArgumentBuilder)Commands.literal((String)"tpnext").requires(source -> source.hasPermission(4))).executes(CommandRegistry::teleportToNextBiome)));
    }

    private static int find_poi(CommandContext<CommandSourceStack> ctx, WoverPoiType poi) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Vec3 pos = source.getPosition();
        ServerLevel level = source.getLevel();
        BlockPos.MutableBlockPos mPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z).mutable();
        System.out.println("Searching POI: " + String.valueOf(poi.key));
        Optional found = poi.findPoiAround(level, (BlockPos)mPos, false, level.getWorldBorder());
        System.out.println("Found at: " + String.valueOf(found.orElse(null)));
        if (found.isPresent()) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)((BlockPos)found.get()), (Block)Blocks.YELLOW_CONCRETE);
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)mPos, (Block)Blocks.LIGHT_BLUE_CONCRETE);
        } else {
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)mPos, (Block)Blocks.RED_CONCRETE);
        }
        return 1;
    }

    private static int teleportToNextBiome(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos target;
        BlockState state;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Iterable biomeIterator = ((Registry)WorldState.registryAccess().registry(Registries.BIOME).orElseThrow()).getTagOrEmpty(BiomeTags.IS_END);
        LinkedList<Holder> biomes = new LinkedList<Holder>();
        for (Holder biome : biomeIterator) {
            biomes.add(biome);
        }
        if (biomeIndex < 0 || biomeIndex >= biomes.size()) {
            source.sendFailure((Component)Component.literal((String)"Failed to find the next Biome...").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
            return 0;
        }
        final Holder biome = (Holder)biomes.get(biomeIndex);
        source.sendSuccess(() -> Component.literal((String)("Locating Biome " + String.valueOf(biome))).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN)), false);
        biomeIndex = (biomeIndex + 1) % biomes.size();
        BlockPos currentPosition = new BlockPos((int)source.getPosition().x, (int)source.getPosition().y, (int)source.getPosition().z);
        BlockPos biomePosition = (BlockPos)source.getLevel().findClosestBiome3d(b -> b.is(biome), currentPosition, 12800, 32, 64).getFirst();
        final String biomeName = biome.toString();
        if (biomePosition == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)biomeName);
        }
        ServerPlayer player = source.getPlayerOrException();
        double yPos = source.getPosition().y();
        boolean didWrap = false;
        do {
            target = new BlockPos(biomePosition.getX(), (int)yPos, biomePosition.getZ());
            state = player.level().getBlockState(target);
            if (!((yPos -= 1.0) <= (double)(player.level().getMinBuildHeight() + 1))) continue;
            if (didWrap) break;
            yPos = 127.0;
            didWrap = true;
        } while (!state.isAir() && yPos > (double)player.level().getMinBuildHeight() && yPos < (double)player.level().getMaxBuildHeight());
        Vector3d targetPlayerPos = new Vector3d((double)target.getX() + 0.5, (double)(target.getY() - 1), (double)target.getZ() + 0.5);
        player.connection.teleport(targetPlayerPos.x, targetPlayerPos.y, targetPlayerPos.z, 0.0f, 0.0f, Collections.EMPTY_SET);
        ResourceOrTagKeyArgument.Result result = new ResourceOrTagKeyArgument.Result(){

            public Either<ResourceKey, TagKey> unwrap() {
                return Either.left((Object)((ResourceKey)biome.unwrap().orThrow()));
            }

            public Optional<ResourceOrTagKeyArgument.Result> cast(ResourceKey resourceKey) {
                return Optional.empty();
            }

            public String asPrintable() {
                return biomeName;
            }

            public boolean test(Object o) {
                return false;
            }
        };
        ResourceKey a = (ResourceKey)biome.unwrapKey().orElseThrow();
        if (WorldState.allStageRegistryAccess() != null) {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
            Holder h = (Holder)WorldState.allStageRegistryAccess().registryOrThrow(Registries.BIOME).getHolder(a).orElseThrow();
            stopwatch.stop();
            return LocateCommand.showLocateResult((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)result, (BlockPos)currentPosition, (Pair)new Pair((Object)biomePosition, (Object)h), (String)"commands.locatebiome.success", (boolean)false, (Duration)stopwatch.elapsed());
        }
        return 1;
    }
}

