/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.complexmaterials.MaterialManager;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public class ColoredMaterial
implements MaterialManager.Material {
    private static final Map<Integer, ItemLike> DYES = Maps.newHashMap();
    private static final Map<Integer, String> COLORS = Maps.newHashMap();
    private final Map<Integer, Block> colors = Maps.newHashMap();
    private List<MaterialManager.MaterialRecipe> RECIPES;

    public ColoredMaterial(Function<BlockBehaviour.Properties, Block> constructor, Block source, boolean craftEight) {
        this(ColoredMaterial.resolveBaseName(source), constructor, source, COLORS, DYES, craftEight);
    }

    public ColoredMaterial(String baseName, Function<BlockBehaviour.Properties, Block> constructor, Block source, boolean craftEight) {
        this(baseName, constructor, source, COLORS, DYES, craftEight);
    }

    public ColoredMaterial(String baseName, Function<BlockBehaviour.Properties, Block> constructor, Block source, Map<Integer, String> colors, Map<Integer, ItemLike> dyes, boolean craftEight) {
        if (ModCore.isDatagen()) {
            this.RECIPES = new ArrayList<MaterialManager.MaterialRecipe>(colors.size());
            MaterialManager.register(this);
        }
        String id = ColoredMaterial.requireBaseName(baseName, source);
        colors.forEach((color, name) -> {
            String blockName = id + "_" + name;
            Block block = (Block)constructor.apply(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).mapColor(MapColor.COLOR_BLACK));
            EndBlocks.registerBlock(blockName, block, new TagKey[0]);
            if (ModCore.isDatagen()) {
                this.RECIPES.add(context -> {
                    if (craftEight) {
                        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(blockName), (ItemLike)block).outputCount(8).shape(new String[]{"###", "#D#", "###"}).addMaterial('#', new ItemLike[]{source}).addMaterial('D', new ItemLike[]{(ItemLike)dyes.get(color)}).build(context);
                    } else {
                        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(blockName), (ItemLike)block).shapeless().addMaterial('#', new ItemLike[]{source}).addMaterial('D', new ItemLike[]{(ItemLike)dyes.get(color)}).build(context);
                    }
                });
            }
            this.colors.put((Integer)color, block);
            BlocksHelper.addBlockColor((Block)block, (int)color);
        });
    }

    public ColoredMaterial(Function<BlockBehaviour.Properties, Block> constructor, Block source, Map<Integer, String> colors, Map<Integer, ItemLike> dyes, boolean craftEight) {
        this(ColoredMaterial.resolveBaseName(source), constructor, source, colors, dyes, craftEight);
    }

    public Block getByColor(DyeColor color) {
        return this.colors.get(color.getMapColor().col);
    }

    public Block getByColor(int color) {
        return this.colors.get(color);
    }

    @Override
    public void registerRecipes(RecipeOutput context) {
        if (this.RECIPES != null) {
            this.RECIPES.forEach(r -> r.registerRecipes(context));
        }
    }

    @Override
    public void registerBlockTags(TagBootstrapContext<Block> context) {
    }

    @Override
    public void registerItemTags(ItemTagBootstrapContext context) {
    }

    private static String resolveBaseName(Block source) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)source);
        if (key == null) {
            throw new IllegalStateException("ColoredMaterial base block is not registered yet: " + String.valueOf(source));
        }
        return key.getPath();
    }

    private static String requireBaseName(String baseName, Block source) {
        if (baseName == null || baseName.isBlank()) {
            throw new IllegalArgumentException("ColoredMaterial base name is required for " + String.valueOf(source));
        }
        return baseName;
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            int colorRGB = color.getMapColor().col;
            COLORS.put(colorRGB, color.getName());
            DYES.put(colorRGB, (ItemLike)DyeItem.byColor((DyeColor)color));
        }
    }
}

