/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.entity.EndFishEntity;
import org.betterx.betterend.entity.model.EndFishEntityModel;
import org.betterx.betterend.registry.EndEntitiesRenders;

public class RendererEntityEndFish
extends MobRenderer<EndFishEntity, EndFishEntityModel> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[8];
    private static final RenderType[] GLOW = new RenderType[8];

    public RendererEntityEndFish(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new EndFishEntityModel(ctx.bakeLayer(EndEntitiesRenders.END_FISH_MODEL)), 0.5f);
        this.addLayer((RenderLayer)new EyesLayer<EndFishEntity, EndFishEntityModel>(this, (RenderLayerParent)this){

            public RenderType renderType() {
                return GLOW[0];
            }

            public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, EndFishEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = vertexConsumers.getBuffer(GLOW[entity.getVariant()]);
                ((EndFishEntityModel)this.getParentModel()).renderToBuffer(matrices, vertexConsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
            }
        });
    }

    protected void scale(EndFishEntity entity, PoseStack matrixStack, float f) {
        float scale = entity.getScale();
        matrixStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(EndFishEntity entity) {
        return TEXTURE[entity.getVariant()];
    }

    static {
        for (int i = 0; i < 8; ++i) {
            RendererEntityEndFish.TEXTURE[i] = BetterEnd.C.mk("textures/entity/end_fish/end_fish_" + i + ".png");
            RendererEntityEndFish.GLOW[i] = RenderType.eyes((ResourceLocation)BetterEnd.C.mk("textures/entity/end_fish/end_fish_" + i + "_glow.png"));
        }
    }
}

