/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.betterx.bclib.client.render.HumanoidArmorRenderer;
import org.betterx.bclib.items.BaseArmorItem;
import org.betterx.betterend.effects.EndStatusEffects;
import org.betterx.betterend.item.material.EndArmorMaterial;
import org.betterx.betterend.item.model.CrystaliteArmorRenderer;

public class CrystaliteArmor
extends BaseArmorItem {
    public static final MutableComponent CHEST_DESC;
    public static final MutableComponent BOOTS_DESC;
    private boolean clientInitDone;

    public CrystaliteArmor(ArmorItem.Type type, Item.Properties settings) {
        super(EndArmorMaterial.CRYSTALITE, type, settings);
    }

    public static boolean hasFullSet(LivingEntity owner) {
        for (ItemStack armorStack : owner.getArmorSlots()) {
            if (armorStack.getItem() instanceof CrystaliteArmor) continue;
            return false;
        }
        return true;
    }

    public static void applySetEffect(LivingEntity owner) {
        if ((owner.tickCount & 0x3F) == 0) {
            owner.addEffect(new MobEffectInstance(EndStatusEffects.CRYSTALITE_HEALTH_REGEN));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        if (this.clientInitDone) {
            return;
        }
        this.clientInitDone = true;
        consumer.accept(new IClientItemExtensions(this){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                CrystaliteArmorRenderer renderer = CrystaliteArmorRenderer.getInstance();
                HumanoidModel<LivingEntity> model = renderer.modelFor(livingEntity, slot);
                if (model == null) {
                    return original;
                }
                HumanoidModel<?> originalTyped = original;
                originalTyped.copyPropertiesTo(model);
                if (model instanceof HumanoidArmorRenderer.CopyExtraState) {
                    HumanoidArmorRenderer.CopyExtraState copy = (HumanoidArmorRenderer.CopyExtraState)model;
                    copy.copyPropertiesFrom(originalTyped);
                }
                return model;
            }
        });
    }

    static {
        Style descStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.ITALIC});
        CHEST_DESC = Component.translatable((String)"tooltip.armor.crystalite_chest");
        CHEST_DESC.setStyle(descStyle);
        BOOTS_DESC = Component.translatable((String)"tooltip.armor.crystalite_boots");
        BOOTS_DESC.setStyle(descStyle);
    }
}

