/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item.material;

import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndTags;
import org.jetbrains.annotations.NotNull;

public enum EndToolMaterial implements Tier
{
    THALLASIUM((TagKey<Block>)Tiers.IRON.getIncorrectBlocksForDrops(), 2, 320, 7.0f, 1.5f, 12, () -> EndBlocks.THALLASIUM.ingot),
    TERMINITE((TagKey<Block>)Tiers.DIAMOND.getIncorrectBlocksForDrops(), 3, 1230, 8.5f, 3.0f, 14, () -> EndBlocks.TERMINITE.ingot),
    AETERNIUM(EndTags.INCORRECT_FOR_AETERNIUM_TOOL, 5, 2196, 10.0f, 4.5f, 18, () -> EndItems.AETERNIUM_INGOT);

    private final int uses;
    private final float speed;
    private final int level;
    private final int enchantibility;
    private final float damage;
    private final Supplier<ItemLike> reapair;
    public final TagKey<Block> incorrectBlocksForDrops;

    private EndToolMaterial(TagKey<Block> incorrectBlocksForDrops, int level, int uses, float speed, float damage, int enchantibility, Supplier<ItemLike> reapair) {
        this.incorrectBlocksForDrops = incorrectBlocksForDrops;
        this.uses = uses;
        this.speed = speed;
        this.level = level;
        this.enchantibility = enchantibility;
        this.damage = damage;
        this.reapair = reapair;
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getLevel() {
        return this.level;
    }

    public int getEnchantmentValue() {
        return this.enchantibility;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.of((ItemLike[])new ItemLike[]{this.reapair.get()});
    }
}

