/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item.model;

import com.google.common.collect.Lists;
import java.util.Collections;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;
import org.betterx.betterend.registry.EndEntitiesRenders;

public class CrystaliteLeggingsModel
extends HumanoidModel<LivingEntity> {
    final ModelPart myBody;
    final ModelPart myLeftLeg;
    final ModelPart myRightLeg;

    public static LayerDefinition getTexturedModelData() {
        float scale = 1.0f;
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        modelPartData.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        modelPartData.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.ZERO);
        modelPartData.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.ZERO);
        CubeDeformation deformation = new CubeDeformation(scale);
        modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.ZERO);
        modelPartData.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        modelPartData.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)48);
    }

    public static CrystaliteLeggingsModel createModel(EntityModelSet entityModelSet) {
        return new CrystaliteLeggingsModel(entityModelSet == null ? CrystaliteLeggingsModel.getTexturedModelData().bakeRoot() : entityModelSet.bakeLayer(EndEntitiesRenders.CRYSTALITE_LEGGINGS));
    }

    public CrystaliteLeggingsModel(ModelPart modelPart) {
        super(modelPart, RenderType::entityTranslucent);
        this.myBody = modelPart.getChild("body");
        this.myLeftLeg = modelPart.getChild("left_leg");
        this.myRightLeg = modelPart.getChild("right_leg");
    }

    protected Iterable<ModelPart> headParts() {
        return Collections::emptyIterator;
    }

    protected Iterable<ModelPart> bodyParts() {
        return Lists.newArrayList((Object[])new ModelPart[]{this.myBody, this.myRightLeg, this.myLeftLeg});
    }
}

