/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChorusFlowerBlock.class}, priority=100)
public abstract class ChorusFlowerBlockMixin
extends Block {
    private static final VoxelShape SHAPE_FULL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_HALF = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    @Final
    @Shadow
    private Block plant;

    public ChorusFlowerBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"canSurvive"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_canSurvive(BlockState state, LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> info) {
        if (world.getBlockState(pos.below()).is(EndBlocks.CHORUS_NYLIUM)) {
            info.setReturnValue((Object)true);
            info.cancel();
        }
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo info) {
        int i;
        BlockPos up;
        if (world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES) && world.isEmptyBlock(up = pos.above()) && up.getY() < 256 && (i = ((Integer)state.getValue((Property)ChorusFlowerBlock.AGE)).intValue()) < 5) {
            this.placeGrownFlower((Level)world, up, i + 1);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)((BlockState)this.plant.defaultBlockState().setValue((Property)ChorusPlantBlock.UP, (Comparable)Boolean.valueOf(true))).setValue((Property)ChorusPlantBlock.DOWN, (Comparable)Boolean.valueOf(true))));
            info.cancel();
        }
    }

    @Shadow
    private void placeGrownFlower(Level world, BlockPos pos, int age) {
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (GeneratorOptions.changeChorusPlant()) {
            return (Integer)state.getValue((Property)ChorusFlowerBlock.AGE) == 5 ? SHAPE_HALF : SHAPE_FULL;
        }
        return super.getShape(state, world, pos, context);
    }

    @Inject(method={"placeDeadFlower"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_placeDeadFlower(Level world, BlockPos pos, CallbackInfo info) {
        BlockState down = world.getBlockState(pos.below());
        if (down.is(Blocks.CHORUS_PLANT) || down.is(CommonBlockTags.END_STONES)) {
            world.setBlock(pos, (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.AGE_5, (Comparable)Integer.valueOf(5)), 2);
            world.levelEvent(1034, pos, 0);
        }
        info.cancel();
    }
}

