/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.state.api.WorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpikeFeature.EndSpike.class})
public class EndSpikeMixin {
    @Final
    @Shadow
    private int height;

    @Inject(method={"getHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_getSpikeHeight(CallbackInfoReturnable<Integer> info) {
        if (!GeneratorOptions.isDirectSpikeHeight()) {
            int x = this.getCenterX();
            int z = this.getCenterZ();
            String pillarID = String.format("%d_%d", x, z);
            CompoundTag pillar = WorldConfig.getCompoundTag((ModCore)BetterEnd.C, (String)"pillars");
            int minY = pillar.contains(pillarID) ? pillar.getInt(pillarID) : 65;
            int maxY = minY + this.height - 54;
            info.setReturnValue((Object)maxY);
        }
    }

    @Shadow
    public int getCenterX() {
        return 0;
    }

    @Shadow
    public int getCenterZ() {
        return 0;
    }
}

