/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.betterend.particle.InfusionParticleType;

public class InfusionParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;

    public InfusionParticle(ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ, float[] palette, SpriteSet spriteProvider) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.setSpriteFromAge(spriteProvider);
        this.spriteProvider = spriteProvider;
        this.setColor(palette[0], palette[1], palette[2]);
        this.setAlpha(palette[3]);
        this.xd = velocityX * 0.1;
        this.yd = velocityY * 0.1;
        this.zd = velocityZ * 0.1;
        this.lifetime = (int)(3.0f / (this.random.nextFloat() * 0.9f + 0.1f));
        this.quadSize *= 0.9f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.spriteProvider);
            double velocityX = 2.0 * this.xd * this.random.nextDouble();
            double velocityY = 3.0 * this.yd * this.random.nextDouble();
            double velocityZ = 2.0 * this.zd * this.random.nextDouble();
            this.move(velocityX, velocityY, velocityZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class InfusionFactory
    implements ParticleProvider<InfusionParticleType> {
        private final SpriteSet spriteProvider;

        public InfusionFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(InfusionParticleType particleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new InfusionParticle(clientWorld, d, e, f, g, h, i, particleType.getPalette(), this.spriteProvider);
        }
    }
}

