/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import java.util.function.Function;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.entity.model.CubozoaEntityModel;
import org.betterx.betterend.entity.model.DragonflyEntityModel;
import org.betterx.betterend.entity.model.EndFishEntityModel;
import org.betterx.betterend.entity.model.EndSlimeEntityModel;
import org.betterx.betterend.entity.model.SilkMothEntityModel;
import org.betterx.betterend.entity.render.RendererEntityCubozoa;
import org.betterx.betterend.entity.render.RendererEntityDragonfly;
import org.betterx.betterend.entity.render.RendererEntityEndFish;
import org.betterx.betterend.entity.render.RendererEntityEndSlime;
import org.betterx.betterend.entity.render.RendererEntityShadowWalker;
import org.betterx.betterend.entity.render.SilkMothEntityRenderer;
import org.betterx.betterend.item.model.ArmoredElytraModel;
import org.betterx.betterend.item.model.CrystaliteBootsModel;
import org.betterx.betterend.item.model.CrystaliteChestplateModel;
import org.betterx.betterend.item.model.CrystaliteHelmetModel;
import org.betterx.betterend.item.model.CrystaliteLeggingsModel;
import org.betterx.betterend.registry.EndEntities;

@OnlyIn(value=Dist.CLIENT)
public class EndEntitiesRenders {
    public static final ModelLayerLocation DRAGONFLY_MODEL = EndEntitiesRenders.registerMain("dragonfly");
    public static final ModelLayerLocation END_SLIME_SHELL_MODEL = EndEntitiesRenders.registerMain("endslime_shell");
    public static final ModelLayerLocation END_SLIME_MODEL = EndEntitiesRenders.registerMain("endslime");
    public static final ModelLayerLocation END_FISH_MODEL = EndEntitiesRenders.registerMain("endfish");
    public static final ModelLayerLocation CUBOZOA_MODEL = EndEntitiesRenders.registerMain("cubozoa");
    public static final ModelLayerLocation SILK_MOTH_MODEL = EndEntitiesRenders.registerMain("silkmoth");
    public static final ModelLayerLocation TEST_MODEL = EndEntitiesRenders.registerMain("test");
    public static final ModelLayerLocation ARMORED_ELYTRA = EndEntitiesRenders.registerMain("armored_elytra");
    public static final ModelLayerLocation CRYSTALITE_CHESTPLATE = EndEntitiesRenders.registerMain("crystalite_chestplate");
    public static final ModelLayerLocation CRYSTALITE_CHESTPLATE_THIN = EndEntitiesRenders.registerMain("crystalite_chestplate_thin");
    public static final ModelLayerLocation CRYSTALITE_HELMET = EndEntitiesRenders.registerMain("crystalite_helmet");
    public static final ModelLayerLocation CRYSTALITE_LEGGINGS = EndEntitiesRenders.registerMain("crystalite_leggings");
    public static final ModelLayerLocation CRYSTALITE_BOOTS = EndEntitiesRenders.registerMain("crystalite_boots");

    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EndEntitiesRenders.register(event, EndEntities.DRAGONFLY.type(), RendererEntityDragonfly::new);
        EndEntitiesRenders.register(event, EndEntities.END_SLIME.type(), RendererEntityEndSlime::new);
        EndEntitiesRenders.register(event, EndEntities.END_FISH.type(), RendererEntityEndFish::new);
        EndEntitiesRenders.register(event, EndEntities.SHADOW_WALKER.type(), RendererEntityShadowWalker::new);
        EndEntitiesRenders.register(event, EndEntities.CUBOZOA.type(), RendererEntityCubozoa::new);
        EndEntitiesRenders.register(event, EndEntities.SILK_MOTH.type(), SilkMothEntityRenderer::new);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(DRAGONFLY_MODEL, DragonflyEntityModel::getTexturedModelData);
        event.registerLayerDefinition(END_SLIME_SHELL_MODEL, EndSlimeEntityModel::getShellOnlyTexturedModelData);
        event.registerLayerDefinition(END_SLIME_MODEL, EndSlimeEntityModel::getCompleteTexturedModelData);
        event.registerLayerDefinition(END_FISH_MODEL, EndFishEntityModel::getTexturedModelData);
        event.registerLayerDefinition(CUBOZOA_MODEL, CubozoaEntityModel::getTexturedModelData);
        event.registerLayerDefinition(SILK_MOTH_MODEL, SilkMothEntityModel::getTexturedModelData);
        event.registerLayerDefinition(ARMORED_ELYTRA, ArmoredElytraModel::getTexturedModelData);
        event.registerLayerDefinition(CRYSTALITE_CHESTPLATE, CrystaliteChestplateModel::getRegularTexturedModelData);
        event.registerLayerDefinition(CRYSTALITE_CHESTPLATE_THIN, CrystaliteChestplateModel::getThinTexturedModelData);
        event.registerLayerDefinition(CRYSTALITE_HELMET, CrystaliteHelmetModel::getTexturedModelData);
        event.registerLayerDefinition(CRYSTALITE_LEGGINGS, CrystaliteLeggingsModel::getTexturedModelData);
        event.registerLayerDefinition(CRYSTALITE_BOOTS, CrystaliteBootsModel::getTexturedModelData);
    }

    private static void register(EntityRenderersEvent.RegisterRenderers event, EntityType<?> type, Function<EntityRendererProvider.Context, MobRenderer> renderer) {
        event.registerEntityRenderer(type, renderer::apply);
    }

    private static ModelLayerLocation registerMain(String id) {
        return new ModelLayerLocation(BetterEnd.C.mk(id), "main");
    }
}

