/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.bclib.particles.BCLParticleType;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.particle.FireflyParticle;
import org.betterx.betterend.particle.InfusionParticle;
import org.betterx.betterend.particle.InfusionParticleType;
import org.betterx.betterend.particle.ParticleBlackSpore;
import org.betterx.betterend.particle.ParticleGeyser;
import org.betterx.betterend.particle.ParticleGlowingSphere;
import org.betterx.betterend.particle.ParticleJungleSpore;
import org.betterx.betterend.particle.ParticleSnowflake;
import org.betterx.betterend.particle.ParticleSulphur;
import org.betterx.betterend.particle.ParticleTenaneaPetal;
import org.betterx.betterend.particle.PaticlePortalSphere;
import org.betterx.betterend.particle.SmaragdantParticle;

public class EndParticles {
    public static SimpleParticleType GLOWING_SPHERE;
    public static SimpleParticleType PORTAL_SPHERE;
    public static ParticleType<InfusionParticleType> INFUSION;
    public static SimpleParticleType SULPHUR_PARTICLE;
    public static SimpleParticleType GEYSER_PARTICLE;
    public static SimpleParticleType SNOWFLAKE;
    public static SimpleParticleType AMBER_SPHERE;
    public static SimpleParticleType BLACK_SPORE;
    public static SimpleParticleType TENANEA_PETAL;
    public static SimpleParticleType JUNGLE_SPORE;
    public static SimpleParticleType FIREFLY;
    public static SimpleParticleType SMARAGDANT;
    private static boolean registered;

    public static void onRegister(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.PARTICLE_TYPE)) {
            return;
        }
        EndParticles.registerTypes();
    }

    private static void registerTypes() {
        if (registered) {
            return;
        }
        registered = true;
        GLOWING_SPHERE = EndParticles.register("glowing_sphere");
        PORTAL_SPHERE = EndParticles.register("portal_sphere");
        INFUSION = BCLParticleType.register((ResourceLocation)BetterEnd.C.mk("infusion"), InfusionParticleType.CODEC, InfusionParticleType.STREAM_CODEC);
        SULPHUR_PARTICLE = EndParticles.register("sulphur_particle");
        GEYSER_PARTICLE = EndParticles.registerFar("geyser_particle");
        SNOWFLAKE = EndParticles.register("snowflake");
        AMBER_SPHERE = EndParticles.register("amber_sphere");
        BLACK_SPORE = EndParticles.register("black_spore");
        TENANEA_PETAL = EndParticles.register("tenanea_petal");
        JUNGLE_SPORE = EndParticles.register("jungle_spore");
        FIREFLY = EndParticles.register("firefly");
        SMARAGDANT = EndParticles.register("smaragdant_particle");
    }

    public static void registerProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)GLOWING_SPHERE, ParticleGlowingSphere.FactoryGlowingSphere::new);
        event.registerSpriteSet((ParticleType)PORTAL_SPHERE, PaticlePortalSphere.FactoryPortalSphere::new);
        event.registerSpriteSet(INFUSION, InfusionParticle.InfusionFactory::new);
        event.registerSpriteSet((ParticleType)SULPHUR_PARTICLE, ParticleSulphur.FactorySulphur::new);
        event.registerSpriteSet((ParticleType)GEYSER_PARTICLE, ParticleGeyser.FactoryGeyser::new);
        event.registerSpriteSet((ParticleType)SNOWFLAKE, ParticleSnowflake.FactorySnowflake::new);
        event.registerSpriteSet((ParticleType)AMBER_SPHERE, ParticleGlowingSphere.FactoryGlowingSphere::new);
        event.registerSpriteSet((ParticleType)BLACK_SPORE, ParticleBlackSpore.FactoryBlackSpore::new);
        event.registerSpriteSet((ParticleType)TENANEA_PETAL, ParticleTenaneaPetal.FactoryTenaneaPetal::new);
        event.registerSpriteSet((ParticleType)JUNGLE_SPORE, ParticleJungleSpore.FactoryJungleSpore::new);
        event.registerSpriteSet((ParticleType)FIREFLY, FireflyParticle.FireflyParticleFactory::new);
        event.registerSpriteSet((ParticleType)SMARAGDANT, SmaragdantParticle.SmaragdantParticleFactory::new);
    }

    private static SimpleParticleType register(String name) {
        return BCLParticleType.register((ResourceLocation)BetterEnd.C.mk(name));
    }

    private static SimpleParticleType registerFar(String name) {
        return BCLParticleType.register((ResourceLocation)BetterEnd.C.mk(name), (boolean)true);
    }

    public static void ensureStaticallyLoadedServerside() {
    }

    static {
        registered = false;
    }
}

