/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.rituals;

import java.awt.Point;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.blocks.entities.InfusionPedestalEntity;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.particle.InfusionParticleType;
import org.betterx.betterend.recipe.builders.InfusionRecipe;
import org.jetbrains.annotations.NotNull;

public class InfusionRitual
implements Container {
    private static final Point[] PEDESTALS_MAP = new Point[]{new Point(0, 3), new Point(2, 2), new Point(3, 0), new Point(2, -2), new Point(0, -3), new Point(-2, -2), new Point(-3, 0), new Point(-2, 2)};
    private Level world;
    private BlockPos worldPos;
    private RecipeHolder<InfusionRecipe> activeRecipe;
    private boolean isDirty = false;
    private boolean hasRecipe = false;
    private int progress = 0;
    private int time = 0;
    private final PedestalBlockEntity[] catalysts = new PedestalBlockEntity[8];
    private final InfusionPedestalEntity input;

    public InfusionRitual(InfusionPedestalEntity pedestal, Level world, BlockPos pos) {
        this.input = pedestal;
        this.world = world;
        this.worldPos = pos;
    }

    public void configure() {
        if (this.world == null || this.worldPos == null) {
            return;
        }
        for (int i = 0; i < this.catalysts.length; ++i) {
            Point point = PEDESTALS_MAP[i];
            BlockPos.MutableBlockPos checkPos = this.worldPos.mutable().move(Direction.EAST, point.x).move(Direction.NORTH, point.y);
            BlockEntity catalystEntity = this.world.isClientSide ? this.world.getChunkAt((BlockPos)checkPos).getBlockEntity((BlockPos)checkPos, LevelChunk.EntityCreationType.CHECK) : this.world.getBlockEntity((BlockPos)checkPos);
            this.catalysts[i] = catalystEntity instanceof PedestalBlockEntity ? (PedestalBlockEntity)catalystEntity : null;
        }
    }

    public boolean checkRecipe() {
        if (!this.isValid()) {
            return false;
        }
        RecipeHolder recipe = this.world.getRecipeManager().getRecipeFor(InfusionRecipe.TYPE, (RecipeInput)new InfusionInput(), this.world).orElse(null);
        if (this.hasRecipe()) {
            if (recipe == null) {
                this.reset();
                return false;
            }
            if (this.activeRecipe == null || ((InfusionRecipe)recipe.value()).getInfusionTime() != this.time) {
                this.updateRecipe((RecipeHolder<InfusionRecipe>)recipe);
            }
            return true;
        }
        if (recipe != null) {
            this.updateRecipe((RecipeHolder<InfusionRecipe>)recipe);
            return true;
        }
        return false;
    }

    private void updateRecipe(RecipeHolder<InfusionRecipe> recipe) {
        this.activeRecipe = recipe;
        this.hasRecipe = true;
        this.resetTimer();
        this.setChanged();
    }

    private void resetTimer() {
        this.time = this.activeRecipe != null ? ((InfusionRecipe)this.activeRecipe.value()).getInfusionTime() : 0;
        this.progress = 0;
    }

    public void reset() {
        this.activeRecipe = null;
        this.hasRecipe = false;
        this.resetTimer();
        this.setChanged();
    }

    public void tick() {
        if (this.isDirty) {
            this.configure();
            this.isDirty = false;
        }
        if (!this.checkRecipe()) {
            return;
        }
        ++this.progress;
        if (this.progress == this.time) {
            this.clearContent();
            this.input.setItem(0, ((InfusionRecipe)this.activeRecipe.value()).assemble(new InfusionInput(), (HolderLookup.Provider)this.world.registryAccess()));
            Level level = this.world;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.getPlayers(p -> p.position().subtract(new Vec3((double)this.worldPos.getX(), (double)this.worldPos.getY(), (double)this.worldPos.getZ())).length() < 16.0).forEach(p -> BECriteria.INFUSION_FINISHED.trigger(p));
            }
            this.reset();
        } else {
            Level sl = this.world;
            if (sl instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)sl;
                BlockPos target = this.worldPos.above();
                double tx = (double)target.getX() + 0.5;
                double ty = (double)target.getY() + 0.5;
                double tz = (double)target.getZ() + 0.5;
                for (PedestalBlockEntity catalyst : this.catalysts) {
                    ItemStack stack = catalyst.getItem(0);
                    if (stack.isEmpty()) continue;
                    BlockPos start = catalyst.getBlockPos();
                    double sx = (double)start.getX() + 0.5;
                    double sy = (double)start.getY() + 1.25;
                    double sz = (double)start.getZ() + 0.5;
                    serverLevel.sendParticles((ParticleOptions)new InfusionParticleType(stack), sx, sy, sz, 0, tx - sx, ty - sy, tz - sz, 0.5);
                }
            }
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.isValid();
    }

    public boolean isValid() {
        if (this.world == null || this.worldPos == null || this.input == null) {
            return false;
        }
        return Arrays.stream(this.catalysts).noneMatch(Objects::isNull);
    }

    public boolean hasRecipe() {
        return this.hasRecipe;
    }

    public void setLocation(Level world, BlockPos pos) {
        this.world = world;
        this.worldPos = pos;
        this.isDirty = true;
    }

    public void clearContent() {
        if (!this.isValid()) {
            return;
        }
        this.input.clearContent();
        Arrays.stream(this.catalysts).forEach(PedestalBlockEntity::clearContent);
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        return false;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (slot > 8) {
            return ItemStack.EMPTY;
        }
        if (slot == 0) {
            return this.input.getItem(0);
        }
        return this.catalysts[slot - 1].getItem(0);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        return this.removeItemNoUpdate(slot);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot > 8) {
            return ItemStack.EMPTY;
        }
        if (slot == 0) {
            return this.input.removeItemNoUpdate(0);
        }
        return this.catalysts[slot - 1].removeItemNoUpdate(0);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot > 8) {
            return;
        }
        if (slot == 0) {
            this.input.setItem(0, stack);
        } else {
            this.catalysts[slot - 1].setItem(0, stack);
        }
    }

    public void setChanged() {
        if (this.isValid()) {
            this.input.setChanged();
            Arrays.stream(this.catalysts).forEach(PedestalBlockEntity::setChanged);
        }
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void fromTag(CompoundTag tag) {
        if (tag.contains("recipe")) {
            this.hasRecipe = tag.getBoolean("recipe");
            this.progress = tag.getInt("progress");
            this.time = tag.getInt("time");
        }
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (this.hasRecipe()) {
            tag.putBoolean("recipe", this.hasRecipe);
            tag.putInt("progress", this.progress);
            tag.putInt("time", this.time);
        }
        return tag;
    }

    public static Point[] getMap() {
        return PEDESTALS_MAP;
    }

    public class InfusionInput
    implements RecipeInput {
        @NotNull
        public ItemStack getItem(int slot) {
            return InfusionRitual.this.getItem(slot);
        }

        public int size() {
            return InfusionRitual.this.getContainerSize();
        }
    }
}

