/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.features.EndConfiguredCaveFeatures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.betterend.world.biome.EndBiomeKey;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LushSmaragdantCaveBiome
extends EndCaveBiome.Config<LushSmaragdantCaveBiome> {
    public static final MapCodec<Biome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(Biome::new);
    public static final KeyDispatchDataCodec<Biome> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    public static final MapCodec<Biome> NETWORK_CODEC = EndCaveBiome.simpleCaveBiomeNetworkCodec(Biome::new);
    public static final KeyDispatchDataCodec<Biome> NETWORK_KEY_CODEC = KeyDispatchDataCodec.of(NETWORK_CODEC);

    public LushSmaragdantCaveBiome(EndBiomeKey<LushSmaragdantCaveBiome, ?> key) {
        super(key);
    }

    @Override
    public void addCustomBuildData(EndBiomeBuilder builder) {
        super.addCustomBuildData(builder);
        ((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)builder.fogColor(0, 253, 182)).fogDensity(2.0f)).plantsColor(0, 131, 145)).waterAndFogColor(31, 167, 212)).particles((ParticleOptions)EndParticles.SMARAGDANT, 0.001f);
    }

    @Override
    public SurfaceMaterialProvider surfaceMaterial() {
        return new EndBiome.DefaultSurfaceMaterialProvider(this){

            @Override
            public BlockState getTopMaterial() {
                return EndBlocks.CAVE_MOSS.defaultBlockState();
            }
        };
    }

    @Override
    @NotNull
    public EndBiome instantiateBiome(float fogDensity, BiomeKey<?> key, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable ResourceKey<net.minecraft.world.level.biome.Biome> edge, @Nullable ResourceKey<net.minecraft.world.level.biome.Biome> parent, boolean hasCave, SurfaceMaterialProvider surface) {
        return new Biome(fogDensity, (ResourceKey<net.minecraft.world.level.biome.Biome>)key.key, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCave, surface, new WeightedList(), new WeightedList());
    }

    public static class Biome
    extends EndCaveBiome {
        @Override
        public void datagenSetup(BootstrapContext<BiomeData> dataContext) {
            this.addFloorFeature(EndConfiguredCaveFeatures.SMARAGDANT_CRYSTAL.getHolder(dataContext), 1.0f);
            this.addFloorFeature(EndConfiguredCaveFeatures.SMARAGDANT_CRYSTAL_SHARD.getHolder(dataContext), 20.0f);
            this.addCeilFeature(EndConfiguredCaveFeatures.END_STONE_STALACTITE.getHolder(dataContext), 1.0f);
        }

        public KeyDispatchDataCodec<? extends EndCaveBiome> codec() {
            return KEY_CODEC;
        }

        public KeyDispatchDataCodec<? extends EndCaveBiome> networkCodec() {
            return NETWORK_KEY_CODEC;
        }

        protected Biome(float fogDensity, @NotNull ResourceKey<net.minecraft.world.level.biome.Biome> biome, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable ResourceKey<net.minecraft.world.level.biome.Biome> edge, @Nullable ResourceKey<net.minecraft.world.level.biome.Biome> parent, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<Holder<ConfiguredFeature<?, ?>>> floorFeatures, WeightedList<Holder<ConfiguredFeature<?, ?>>> ceilFeatures) {
            super(fogDensity, biome, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCaves, surface, floorFeatures, ceilFeatures);
        }

        @Override
        public float getFloorDensity() {
            return 0.1f;
        }

        @Override
        public float getCeilDensity() {
            return 0.1f;
        }
    }
}

