/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public abstract class InvertedScatterFeature<FC extends ScatterFeatureConfig>
extends Feature<FC> {
    public InvertedScatterFeature(Codec<FC> codec) {
        super(codec);
    }

    public abstract boolean canGenerate(FC var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, BlockPos var5, float var6);

    public abstract void generate(FC var1, WorldGenLevel var2, RandomSource var3, BlockPos var4);

    public boolean place(FeaturePlaceContext<FC> featureConfig) {
        ScatterFeatureConfig cfg = (ScatterFeatureConfig)featureConfig.config();
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        RandomSource random = featureConfig.random();
        BlockPos center = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        int maxY = world.getHeight(Heightmap.Types.WORLD_SURFACE, center.getX(), center.getZ());
        int minY = BlocksHelper.upRay((LevelAccessor)world, (BlockPos)new BlockPos(center.getX(), 0, center.getZ()), (int)maxY);
        for (int y = maxY; y > minY; --y) {
            POS.set(center.getX(), y, center.getZ());
            if (!world.getBlockState((BlockPos)POS).isAir() || world.getBlockState(POS.above()).isAir()) continue;
            float r = MHelper.randRange((float)((float)cfg.radius * 0.5f), (float)cfg.radius, (RandomSource)random);
            int count = MHelper.floor((double)(r * r * MHelper.randRange((float)0.5f, (float)1.5f, (RandomSource)random)));
            for (int i = 0; i < count; ++i) {
                float pr = r * (float)Math.sqrt(random.nextFloat());
                float theta = random.nextFloat() * ((float)Math.PI * 2);
                float x = pr * (float)Math.cos(theta);
                float z = pr * (float)Math.sin(theta);
                POS.set((double)((float)center.getX() + x), (double)(center.getY() - 7), (double)((float)center.getZ() + z));
                int up = BlocksHelper.upRay((LevelAccessor)world, (BlockPos)POS, (int)16);
                if (up > 14) continue;
                POS.setY(POS.getY() + up);
                if (!this.canGenerate(cfg, world, random, center, (BlockPos)POS, r)) continue;
                this.generate(cfg, world, random, (BlockPos)POS);
            }
        }
        return true;
    }
}

