/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public class SinglePlantFeatureConfig
extends ScatterFeatureConfig {
    public static final Codec<SinglePlantFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("state").forGetter(o -> o.plant), (App)Codec.INT.fieldOf("radius").forGetter(o -> o.radius), (App)Codec.BOOL.fieldOf("raw_heightmap").forGetter(o -> o.rawHeightmap), (App)Codec.INT.fieldOf("chance").forGetter(o -> o.chance)).apply((Applicative)instance, SinglePlantFeatureConfig::new));
    public final BlockStateProvider plant;
    public final boolean rawHeightmap;
    public final int chance;

    public SinglePlantFeatureConfig(Block plant, int radius) {
        this((BlockStateProvider)SimpleStateProvider.simple((Block)plant), radius, true, 1);
    }

    public SinglePlantFeatureConfig(Block plant, int radius, int chance) {
        this((BlockStateProvider)SimpleStateProvider.simple((Block)plant), radius, true, chance);
    }

    public SinglePlantFeatureConfig(Block plant, int radius, boolean rawHeightmap) {
        this((BlockStateProvider)SimpleStateProvider.simple((Block)plant), radius, rawHeightmap, 1);
    }

    public SinglePlantFeatureConfig(Block plant, int radius, boolean rawHeightmap, int chance) {
        this((BlockStateProvider)SimpleStateProvider.simple((Block)plant), radius, rawHeightmap, chance);
    }

    public SinglePlantFeatureConfig(BlockStateProvider plant, int radius, boolean rawHeightmap, int chance) {
        super(radius);
        this.plant = plant;
        this.rawHeightmap = rawHeightmap;
        this.chance = chance;
    }

    public BlockState getPlantState(RandomSource rnd, BlockPos pos) {
        return this.plant.getState(rnd, pos);
    }

    public static SinglePlantFeatureConfig charnia(Block plant) {
        return new SinglePlantFeatureConfig(plant, 6);
    }
}

