/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.world.features.ScatterFeature;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public abstract class SkyScatterFeature
extends ScatterFeature<ScatterFeatureConfig> {
    public SkyScatterFeature() {
        super(ScatterFeatureConfig.CODEC);
    }

    @Override
    protected int getChance() {
        return 10;
    }

    @Override
    public boolean canGenerate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        if (!world.isEmptyBlock(blockPos)) {
            return false;
        }
        for (Direction dir : BlocksHelper.HORIZONTAL) {
            if (world.isEmptyBlock(blockPos.relative(dir))) continue;
            return false;
        }
        int maxD = this.getYOffset() + 2;
        int maxV = this.getYOffset() - 2;
        return BlocksHelper.upRay((LevelAccessor)world, (BlockPos)blockPos, (int)maxD) > maxV && BlocksHelper.downRay((LevelAccessor)world, (BlockPos)blockPos, (int)maxD) > maxV;
    }

    @Override
    protected boolean canSpawn(ScatterFeatureConfig cfg, WorldGenLevel world, BlockPos pos) {
        return true;
    }

    @Override
    protected BlockPos getCenterGround(ScatterFeatureConfig cfg, WorldGenLevel world, BlockPos pos) {
        return new BlockPos(pos.getX(), MHelper.randRange((int)32, (int)192, (RandomSource)world.getRandom()), pos.getZ());
    }

    @Override
    protected boolean getGroundPlant(ScatterFeatureConfig cfg, WorldGenLevel world, BlockPos.MutableBlockPos pos) {
        pos.setY(pos.getY() + MHelper.randRange((int)(-this.getYOffset()), (int)this.getYOffset(), (RandomSource)world.getRandom()));
        return true;
    }
}

