/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.BaseVineBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.world.features.InvertedScatterFeature;
import org.betterx.betterend.world.features.VineFeatureConfig;
import org.betterx.wover.block.api.BlockProperties;

public class VineFeature
extends InvertedScatterFeature<VineFeatureConfig> {
    private BlockState plant;
    boolean vine;

    public VineFeature() {
        super(VineFeatureConfig.CODEC);
    }

    @Override
    public boolean canGenerate(VineFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        this.plant = cfg.getPlantState(random, blockPos);
        BlockState state = world.getBlockState(blockPos);
        return state.canBeReplaced() && this.canPlaceBlock(state, world, blockPos);
    }

    @Override
    public void generate(VineFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        int h = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)blockPos, (int)random.nextInt(cfg.maxLength)) - 1;
        if (h > 2) {
            BlockState top = this.getTopState();
            BlockState middle = this.getMiddleState();
            BlockState bottom = this.getBottomState();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos, (BlockState)top);
            for (int i = 1; i < h; ++i) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos.below(i), (BlockState)middle);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)blockPos.below(h), (BlockState)bottom);
        }
    }

    private boolean canPlaceBlock(BlockState state, WorldGenLevel world, BlockPos blockPos) {
        if (this.plant == null) {
            return false;
        }
        Block block = this.plant.getBlock();
        if (block instanceof BaseVineBlock) {
            BaseVineBlock vineBlock = (BaseVineBlock)block;
            this.vine = true;
            return vineBlock.canGenerate(state, (LevelReader)world, blockPos);
        }
        this.vine = false;
        return state.canSurvive((LevelReader)world, blockPos);
    }

    private BlockState getTopState() {
        BlockState state = this.plant;
        return this.vine ? (BlockState)state.setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP) : state;
    }

    private BlockState getMiddleState() {
        BlockState state = this.plant;
        return this.vine ? (BlockState)state.setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE) : state;
    }

    private BlockState getBottomState() {
        BlockState state = this.plant;
        return this.vine ? (BlockState)state.setValue((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM) : state;
    }
}

