/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public abstract class WallScatterFeature<FC extends ScatterFeatureConfig>
extends Feature<FC> {
    private static final Direction[] DIR = BlocksHelper.makeHorizontal();

    public WallScatterFeature(Codec<FC> codec) {
        super(codec);
    }

    public abstract boolean canGenerate(FC var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, Direction var5);

    public abstract void generate(FC var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, Direction var5);

    public boolean place(FeaturePlaceContext<FC> featureConfig) {
        ScatterFeatureConfig cfg = (ScatterFeatureConfig)featureConfig.config();
        RandomSource random = featureConfig.random();
        BlockPos center = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        int maxY = world.getHeight(Heightmap.Types.WORLD_SURFACE, center.getX(), center.getZ());
        int minY = BlocksHelper.upRay((LevelAccessor)world, (BlockPos)new BlockPos(center.getX(), 0, center.getZ()), (int)maxY);
        if (maxY < 10 || maxY < minY) {
            return false;
        }
        int py = MHelper.randRange((int)minY, (int)maxY, (RandomSource)random);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        for (int x = -cfg.radius; x <= cfg.radius; ++x) {
            mut.setX(center.getX() + x);
            for (int y = -cfg.radius; y <= cfg.radius; ++y) {
                mut.setY(py + y);
                block2: for (int z = -cfg.radius; z <= cfg.radius; ++z) {
                    mut.setZ(center.getZ() + z);
                    if (random.nextInt(4) != 0 || !world.isEmptyBlock((BlockPos)mut)) continue;
                    this.shuffle(random);
                    for (Direction dir : DIR) {
                        if (!this.canGenerate(cfg, world, random, (BlockPos)mut, dir)) continue;
                        this.generate(cfg, world, random, (BlockPos)mut, dir);
                        continue block2;
                    }
                }
            }
        }
        return true;
    }

    private void shuffle(RandomSource random) {
        for (int i = 0; i < 4; ++i) {
            int j = random.nextInt(4);
            Direction d = DIR[i];
            WallScatterFeature.DIR[i] = DIR[j];
            WallScatterFeature.DIR[j] = d;
        }
    }
}

