/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.features.EndConfiguredVegetation;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.features.terrain.SpireFeature;

public class FloatingSpireFeature
extends SpireFeature {
    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        float rMin;
        int i;
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        ChunkGenerator chunkGenerator = featureConfig.chunkGenerator();
        int minY = FloatingSpireFeature.getYOnSurface((WorldGenLevel)world, (int)pos.getX(), (int)pos.getZ());
        int y = minY > 57 ? MHelper.floor((double)((float)MHelper.randRange((int)minY, (int)(minY * 2), (RandomSource)random) * 0.5f + 32.0f)) : MHelper.randRange((int)64, (int)192, (RandomSource)random);
        pos = new BlockPos(pos.getX(), y, pos.getZ());
        SDFPrimitive sdf = new SDFSphere().setRadius((float)MHelper.randRange((int)2, (int)3, (RandomSource)random)).setBlock(Blocks.END_STONE);
        int count = MHelper.randRange((int)3, (int)5, (RandomSource)random);
        for (i = 0; i < count; ++i) {
            rMin = (float)i * 1.3f + 2.5f;
            sdf = this.addSegment((SDF)sdf, MHelper.randRange((float)rMin, (float)(rMin + 1.5f), (RandomSource)random), random);
        }
        for (i = count - 1; i > 0; --i) {
            rMin = (float)i * 1.3f + 2.5f;
            sdf = this.addSegment((SDF)sdf, MHelper.randRange((float)rMin, (float)(rMin + 1.5f), (RandomSource)random), random);
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        sdf = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(Math.abs(noise.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1)) * 3.0 + Math.abs(noise.eval((double)vec.x() * 0.3, (double)vec.y() * 0.3 + 100.0, (double)vec.z() * 0.3)) * (double)1.3f))).setSource((SDF)sdf);
        BlockPos center = pos;
        ArrayList support = Lists.newArrayList();
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (info.getStateUp().isAir()) {
                if (random.nextInt(16) == 0) {
                    support.add(info.getPos().above());
                }
                return EndBiome.findTopMaterial(world, info.getPos());
            }
            if (info.getState(Direction.UP, 3).isAir()) {
                return EndBiome.findUnderMaterial(world, info.getPos());
            }
            return info.getState();
        });
        sdf.fillRecursive((ServerLevelAccessor)world, center);
        for (BlockPos bpos : support) {
            Holder biome = world.getBiome(bpos);
            if (!biome.is(EndBiomes.BLOSSOMING_SPIRES.key)) continue;
            EndConfiguredVegetation.TENANEA_BUSH.placeInWorld(world, bpos, random);
        }
        return true;
    }
}

