/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFCoordModify;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFInvert;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFFlatland;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.HydrothermalVentBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.features.EndConfiguredLakeFeature;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class GeyserFeature
extends DefaultFeature {
    private static final Direction[] HORIZONTAL = BlocksHelper.makeHorizontal();

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        int i;
        RandomSource random = featureConfig.random();
        WorldGenLevel world = featureConfig.level();
        BlockPos pos = GeyserFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)featureConfig.origin());
        ChunkGenerator chunkGenerator = featureConfig.chunkGenerator();
        if (pos.getY() < 10) {
            return false;
        }
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        bpos.setY(bpos.getY() - 1);
        BlockState state = world.getBlockState((BlockPos)bpos);
        while (state.is(CommonBlockTags.END_STONES) || !state.getFluidState().isEmpty() && bpos.getY() > 5) {
            bpos.setY(bpos.getY() - 1);
            state = world.getBlockState((BlockPos)bpos);
        }
        if (pos.getY() - bpos.getY() < 25) {
            return false;
        }
        int halfHeight = MHelper.randRange((int)10, (int)20, (RandomSource)random);
        float radius1 = (float)halfHeight * 0.5f;
        float radius2 = (float)halfHeight * 0.1f + 0.5f;
        SDFPrimitive sdf = new SDFCappedCone().setHeight((float)halfHeight).setRadius1(radius1).setRadius2(radius2).setBlock(EndBlocks.SULPHURIC_ROCK.stone);
        sdf = new SDFTranslate().setTranslate(0.0f, (float)(halfHeight - 3), 0.0f).setSource((SDF)sdf);
        int count = halfHeight;
        for (int i2 = 0; i2 < count; ++i2) {
            int py = i2 << 1;
            float delta = (float)i2 / (float)(count - 1);
            float radius = Mth.lerp((float)delta, (float)radius1, (float)radius2) * 1.3f;
            SDFPrimitive bowl = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock(EndBlocks.SULPHURIC_ROCK.stone);
            SDFPrimitive brimstone = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock(EndBlocks.BRIMSTONE);
            brimstone = new SDFTranslate().setTranslate(0.0f, 2.0f, 0.0f).setSource((SDF)brimstone);
            bowl = new SDFSubtraction().setSourceA((SDF)bowl).setSourceB((SDF)brimstone);
            bowl = new SDFUnion().setSourceA((SDF)brimstone).setSourceB((SDF)bowl);
            Direction[] water = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock(Blocks.WATER);
            water = new SDFTranslate().setTranslate(0.0f, 4.0f, 0.0f).setSource((SDF)water);
            bowl = new SDFSubtraction().setSourceA((SDF)bowl).setSourceB((SDF)water);
            bowl = new SDFUnion().setSourceA((SDF)water).setSourceB((SDF)bowl);
            OpenSimplexNoise noise1 = new OpenSimplexNoise(random.nextLong());
            OpenSimplexNoise noise2 = new OpenSimplexNoise(random.nextLong());
            bowl = new SDFCoordModify().setFunction(vec -> {
                float dx = (float)noise1.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1);
                float dz = (float)noise2.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1);
                vec.set(vec.x() + dx, vec.y(), vec.z() + dz);
            }).setSource((SDF)bowl);
            SDFPrimitive cut = new SDFFlatland().setBlock(Blocks.AIR);
            cut = new SDFInvert().setSource((SDF)cut);
            cut = new SDFTranslate().setTranslate(0.0f, radius - 2.0f, 0.0f).setSource((SDF)cut);
            bowl = new SDFSubtraction().setSourceA((SDF)bowl).setSourceB((SDF)cut);
            bowl = new SDFTranslate().setTranslate(radius, (float)py - radius, 0.0f).setSource((SDF)bowl);
            bowl = new SDFRotation().setRotation(Axis.YP, (float)i2 * 4.0f).setSource((SDF)bowl);
            sdf = new SDFUnion().setSourceA((SDF)sdf).setSourceB((SDF)bowl);
        }
        sdf.setReplaceFunction(this.replaceFunc2()).fillRecursive((ServerLevelAccessor)world, pos);
        radius2 *= 0.5f;
        if (radius2 < 0.7f) {
            radius2 = 0.7f;
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        SDFCappedCone obj1 = new SDFCappedCone().setHeight((float)(halfHeight + 5)).setRadius1(radius1 * 0.5f).setRadius2(radius2);
        sdf = new SDFTranslate().setTranslate(0.0f, (float)(halfHeight - 13), 0.0f).setSource((SDF)obj1);
        sdf = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval(vec.x() * 0.3f, vec.y() * 0.3f, vec.z() * 0.3f) * 0.5f)).setSource((SDF)sdf);
        SDFSphere obj2 = new SDFSphere().setRadius(radius1);
        SDFUnary cave = new SDFScale3D().setScale(1.5f, 1.0f, 1.5f).setSource((SDF)obj2);
        cave = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval(vec.x() * 0.1f, vec.y() * 0.1f, vec.z() * 0.1f) * 2.0f)).setSource((SDF)cave);
        cave = new SDFTranslate().setTranslate(0.0f, (float)(-halfHeight - 10), 0.0f).setSource((SDF)cave);
        sdf = new SDFSmoothUnion().setRadius(5.0f).setSourceA((SDF)cave).setSourceB((SDF)sdf);
        obj1.setBlock(WATER);
        obj2.setBlock(WATER);
        sdf.setReplaceFunction(this.replaceFunc2());
        sdf.fillRecursive((ServerLevelAccessor)world, pos);
        obj1.setBlock(EndBlocks.BRIMSTONE);
        obj2.setBlock(EndBlocks.BRIMSTONE);
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-2.0f)).setSource((SDF)sdf).setReplaceFunction(this.replaceFunc1()).fillRecursiveIgnore((ServerLevelAccessor)world, pos, this.ignoreFunc());
        obj1.setBlock(EndBlocks.SULPHURIC_ROCK.stone);
        obj2.setBlock(EndBlocks.SULPHURIC_ROCK.stone);
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-4.0f)).setSource((SDF)cave).setReplaceFunction(this.replaceFunc1()).fillRecursiveIgnore((ServerLevelAccessor)world, pos, this.ignoreFunc());
        obj1.setBlock(Blocks.END_STONE);
        obj2.setBlock(Blocks.END_STONE);
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-6.0f)).setSource((SDF)cave).setReplaceFunction(this.replaceFunc1()).fillRecursiveIgnore((ServerLevelAccessor)world, pos, this.ignoreFunc());
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)WATER);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        count = GeyserFeature.getYOnSurface((WorldGenLevel)world, (int)pos.getX(), (int)pos.getZ()) - pos.getY();
        for (i = 0; i < count; ++i) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)WATER);
            for (Direction dir : BlocksHelper.HORIZONTAL) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut.relative(dir), (BlockState)WATER);
            }
            mut.setY(mut.getY() + 1);
        }
        for (i = 0; i < 150; ++i) {
            mut.set((Vec3i)pos).move(MHelper.floor((double)(random.nextGaussian() * 4.0 + 0.5)), -halfHeight - 10, MHelper.floor((double)(random.nextGaussian() * 4.0 + 0.5)));
            float distRaw = MHelper.length((float)(mut.getX() - pos.getX()), (float)(mut.getZ() - pos.getZ()));
            int dist = MHelper.floor((double)(6.0f - distRaw)) + random.nextInt(2);
            if (dist < 0) continue;
            state = world.getBlockState((BlockPos)mut);
            while (!state.getFluidState().isEmpty() || state.is(CommonBlockTags.WATER_PLANT)) {
                mut.setY(mut.getY() - 1);
                state = world.getBlockState((BlockPos)mut);
            }
            if (!state.is(CommonBlockTags.END_STONES) || world.getBlockState(mut.above()).is(EndBlocks.HYDROTHERMAL_VENT)) continue;
            for (int j = 0; j <= dist; ++j) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.SULPHURIC_ROCK.stone);
                MHelper.shuffle((Object[])HORIZONTAL, (RandomSource)random);
                for (Direction dir : HORIZONTAL) {
                    BlockPos p = mut.relative(dir);
                    if (!random.nextBoolean() || !world.getBlockState(p).is(Blocks.WATER)) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)((BlockState)EndBlocks.TUBE_WORM.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)dir)));
                }
                mut.setY(mut.getY() + 1);
            }
            state = (BlockState)EndBlocks.HYDROTHERMAL_VENT.defaultBlockState().setValue((Property)HydrothermalVentBlock.ACTIVATED, (Comparable)Boolean.valueOf(distRaw < 2.0f));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
            mut.setY(mut.getY() + 1);
            state = world.getBlockState((BlockPos)mut);
            while (state.is(Blocks.WATER)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)EndBlocks.VENT_BUBBLE_COLUMN.defaultBlockState());
                mut.setY(mut.getY() + 1);
                state = world.getBlockState((BlockPos)mut);
            }
        }
        for (i = 0; i < 10; ++i) {
            mut.set((Vec3i)pos).move(MHelper.floor((double)(random.nextGaussian() * 0.7 + 0.5)), -halfHeight - 10, MHelper.floor((double)(random.nextGaussian() * 0.7 + 0.5)));
            float distRaw = MHelper.length((float)(mut.getX() - pos.getX()), (float)(mut.getZ() - pos.getZ()));
            int dist = MHelper.floor((double)(6.0f - distRaw)) + random.nextInt(2);
            if (dist < 0) continue;
            state = world.getBlockState((BlockPos)mut);
            while (state.is(Blocks.WATER)) {
                mut.setY(mut.getY() - 1);
                state = world.getBlockState((BlockPos)mut);
            }
            if (!state.is(CommonBlockTags.END_STONES)) continue;
            for (int j = 0; j <= dist; ++j) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.SULPHURIC_ROCK.stone);
                mut.setY(mut.getY() + 1);
            }
            state = (BlockState)EndBlocks.HYDROTHERMAL_VENT.defaultBlockState().setValue((Property)HydrothermalVentBlock.ACTIVATED, (Comparable)Boolean.valueOf(distRaw < 2.0f));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)state);
            mut.setY(mut.getY() + 1);
            state = world.getBlockState((BlockPos)mut);
            while (state.is(Blocks.WATER)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)EndBlocks.VENT_BUBBLE_COLUMN.defaultBlockState());
                mut.setY(mut.getY() + 1);
                state = world.getBlockState((BlockPos)mut);
            }
        }
        EndConfiguredLakeFeature.SULPHURIC_LAKE.placeInWorld(world, pos, random);
        double distance = (double)radius1 * 1.7;
        BlockPos start = pos.offset((int)(-distance), (int)((double)(-halfHeight - 15) - distance), (int)(-distance));
        BlockPos end = pos.offset((int)distance, (int)((double)(-halfHeight - 5) + distance), (int)distance);
        BlockFixer.fixBlocks((LevelAccessor)world, start, end);
        return true;
    }

    private Function<BlockState, Boolean> replaceFunc1() {
        return state -> state.isAir() || state.is(CommonBlockTags.END_STONES);
    }

    private Function<BlockState, Boolean> replaceFunc2() {
        return state -> {
            if (state.is(CommonBlockTags.END_STONES) || state.is(EndBlocks.HYDROTHERMAL_VENT) || state.is(EndBlocks.SULPHUR_CRYSTAL)) {
                return true;
            }
            return BlocksHelper.replaceableOrPlant((BlockState)state);
        };
    }

    private Function<BlockState, Boolean> ignoreFunc() {
        return state -> state.is(Blocks.WATER) || state.is(Blocks.CAVE_AIR) || state.is(EndBlocks.SULPHURIC_ROCK.stone) || state.is(EndBlocks.BRIMSTONE);
    }
}

