/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.wover.biome.api.BiomeManager;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.config.api.Configs;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public abstract class EndCaveFeatures
extends DefaultFeature {
    private static int errCounter = 0;
    protected static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected static final BlockState END_STONE = Blocks.END_STONE.defaultBlockState();
    protected static final BlockState WATER = Blocks.WATER.defaultBlockState();
    private static final Vec3i[] SPHERE;

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (pos.getX() * pos.getX() + pos.getZ() * pos.getZ() <= 2500) {
            return false;
        }
        if (this.biomeMissingCaves(world, pos)) {
            return false;
        }
        int radius = MHelper.randRange((int)10, (int)30, (RandomSource)random);
        BlockPos center = this.findPos(world, pos, radius, random);
        if (center == null) {
            return false;
        }
        WoverBiomePicker.PickableBiome biome = EndBiomes.getCaveBiome(pos.getX(), pos.getZ());
        Set<BlockPos> caveBlocks = this.generate(world, center, radius, random);
        if (!caveBlocks.isEmpty()) {
            if (biome != null) {
                ChunkGenerator generator = featureConfig.chunkGenerator();
                this.setBiomes(world, biome, caveBlocks);
                Set floorPositions = Sets.newConcurrentHashSet();
                Set ceilPositions = Sets.newConcurrentHashSet();
                caveBlocks.parallelStream().forEach(bpos -> {
                    if (world.getBlockState(bpos).canBeReplaced()) {
                        BlockPos side = bpos.below();
                        if (world.getBlockState(side).is(CommonBlockTags.END_STONES)) {
                            floorPositions.add(side);
                        }
                        if (world.getBlockState(side = bpos.above()).is(CommonBlockTags.END_STONES)) {
                            ceilPositions.add(side);
                        }
                    }
                });
                BlockState surfaceBlock = EndBiome.findTopMaterial((Holder<Biome>)biome.biome);
                BiomeData biomeData = biome.biomeData;
                if (biomeData instanceof EndCaveBiome) {
                    EndCaveBiome caveBiome = (EndCaveBiome)biomeData;
                    this.placeFloor(world, generator, caveBiome, floorPositions, random, surfaceBlock);
                    this.placeCeil(world, generator, caveBiome, ceilPositions, random);
                    this.placeWalls(world, generator, caveBiome, caveBlocks, random);
                } else if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue() && errCounter < 25) {
                    ++errCounter;
                    BetterEnd.LOGGER.error(String.valueOf(biome.biome.unwrapKey().map(ResourceKey::location).orElse(null)) + " is not an EndCaveBiome.");
                }
            }
            this.fixBlocks(world, caveBlocks);
        }
        return true;
    }

    protected abstract Set<BlockPos> generate(WorldGenLevel var1, BlockPos var2, int var3, RandomSource var4);

    protected void placeFloor(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> floorPositions, RandomSource random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity();
        floorPositions.forEach(pos -> {
            Holder<? extends ConfiguredFeature<?, ?>> feature;
            if (!surfaceBlock.is(Blocks.END_STONE)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)surfaceBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getFloorFeature(random)) != null && feature.isBound()) {
                ((ConfiguredFeature)feature.value()).place(world, generator, random, pos.above());
            }
        });
    }

    protected void placeCeil(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> ceilPositions, RandomSource random) {
        float density = biome.getCeilDensity();
        ceilPositions.forEach(pos -> {
            Holder<? extends ConfiguredFeature<?, ?>> feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)ceilBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getCeilFeature(random)) != null && feature.isBound()) {
                ((ConfiguredFeature)feature.value()).place(world, generator, random, pos.below());
            }
        });
    }

    protected void placeWalls(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> positions, RandomSource random) {
        HashSet placed = Sets.newHashSet();
        positions.forEach(pos -> {
            BlockState wallBlock;
            if (random.nextInt(4) == 0 && this.hasOpenSide((BlockPos)pos, positions) && (wallBlock = biome.getWall((BlockPos)pos)) != null) {
                for (Vec3i offset : SPHERE) {
                    BlockPos wallPos = pos.offset(offset);
                    if (positions.contains(wallPos) || placed.contains(wallPos) || !world.getBlockState(wallPos).is(CommonBlockTags.END_STONES)) continue;
                    wallBlock = biome.getWall(wallPos);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)wallPos, (BlockState)wallBlock);
                    placed.add(wallPos);
                }
            }
        });
    }

    private boolean hasOpenSide(BlockPos pos, Set<BlockPos> positions) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (positions.contains(pos.relative(dir))) continue;
            return true;
        }
        return false;
    }

    protected void setBiomes(WorldGenLevel world, WoverBiomePicker.PickableBiome biome, Set<BlockPos> blocks) {
        blocks.forEach(pos -> this.setBiome(world, (BlockPos)pos, biome));
    }

    protected void setBiome(WorldGenLevel world, BlockPos pos, WoverBiomePicker.PickableBiome biome) {
        BiomeManager.setBiome((LevelAccessor)world, (BlockPos)pos, (Holder)biome.biome);
    }

    private BlockPos findPos(WorldGenLevel world, BlockPos pos, int radius, RandomSource random) {
        int top = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ());
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
        bpos.setX(pos.getX());
        bpos.setZ(pos.getZ());
        bpos.setY(top - 1);
        BlockState state = world.getBlockState((BlockPos)bpos);
        while (!state.is(CommonBlockTags.END_STONES) && bpos.getY() > 5) {
            bpos.setY(bpos.getY() - 1);
            state = world.getBlockState((BlockPos)bpos);
        }
        if (bpos.getY() < 10) {
            return null;
        }
        top = (int)((float)bpos.getY() - ((float)radius * 1.3f + 5.0f));
        while (state.is(CommonBlockTags.END_STONES) || !state.getFluidState().isEmpty() && bpos.getY() > 5) {
            bpos.setY(bpos.getY() - 1);
            state = world.getBlockState((BlockPos)bpos);
        }
        int bottom = (int)((float)bpos.getY() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return null;
        }
        return new BlockPos(pos.getX(), MHelper.randRange((int)bottom, (int)top, (RandomSource)random), pos.getZ());
    }

    protected void fixBlocks(WorldGenLevel world, Set<BlockPos> caveBlocks) {
        BlockPos pos = caveBlocks.iterator().next();
        BlockPos.MutableBlockPos start = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        BlockPos.MutableBlockPos end = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        caveBlocks.forEach(bpos -> {
            if (bpos.getX() < start.getX()) {
                start.setX(bpos.getX());
            }
            if (bpos.getX() > end.getX()) {
                end.setX(bpos.getX());
            }
            if (bpos.getY() < start.getY()) {
                start.setY(bpos.getY());
            }
            if (bpos.getY() > end.getY()) {
                end.setY(bpos.getY());
            }
            if (bpos.getZ() < start.getZ()) {
                start.setZ(bpos.getZ());
            }
            if (bpos.getZ() > end.getZ()) {
                end.setZ(bpos.getZ());
            }
        });
        BlockFixer.fixBlocks((LevelAccessor)world, start.offset(-2, -2, -2), end.offset(2, 2, 2));
    }

    protected boolean isWaterNear(WorldGenLevel world, BlockPos pos) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (world.getFluidState(pos.relative(dir, 5)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected boolean biomeMissingCaves(WorldGenLevel world, BlockPos pos) {
        for (int x = -1; x < 1; ++x) {
            for (int z = -1; z < 1; ++z) {
                BlockPos testPos = pos.offset(x << 4, 0, z << 4);
                Holder biome = WoverBiomePicker.getBiomeAt((WorldGenLevel)world, (BlockPos)testPos);
                if (biome == null) continue;
                BiomeData biomeData = BiomeManager.biomeDataForHolder((Holder)biome);
                boolean hasCaves = true;
                if (biomeData instanceof EndBiome) {
                    EndBiome endBiome = (EndBiome)biomeData;
                    hasCaves = endBiome.hasCaves();
                }
                if (hasCaves || !biome.is(CommonBiomeTags.IS_END_LAND)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ArrayList prePos = Lists.newArrayList();
        int radius = 5;
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            int x2 = x * x;
            for (int y = -radius; y <= radius; ++y) {
                int y2 = y * y;
                for (int z = -radius; z <= radius; ++z) {
                    int z2 = z * z;
                    if (x2 + y2 + z2 >= r2) continue;
                    prePos.add(new Vec3i(x, y, z));
                }
            }
        }
        SPHERE = prePos.toArray(new Vec3i[0]);
    }
}

