/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.betterend.world.features.terrain.caves.EndCaveFeatures;
import org.betterx.wover.biome.api.BiomeManager;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.config.api.Configs;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class TunelCaveFeature
extends EndCaveFeatures {
    private static int tunnelFloorErrCounter = 0;
    private static int tunnelCeilErrCounter = 0;
    private static int tunnelWallErrCounter = 0;

    private Set<BlockPos> generate(WorldGenLevel world, BlockPos center, RandomSource random) {
        int cz;
        int cx = center.getX() >> 4;
        if ((long)cx * (long)cx + (long)(cz = center.getZ() >> 4) + (long)cz < 256L) {
            return Sets.newHashSet();
        }
        int x1 = cx << 4;
        int z1 = cz << 4;
        int x2 = x1 + 16;
        int z2 = z1 + 16;
        LegacyRandomSource rand = new LegacyRandomSource(world.getSeed());
        OpenSimplexNoise noiseH = new OpenSimplexNoise(rand.nextInt());
        OpenSimplexNoise noiseV = new OpenSimplexNoise(rand.nextInt());
        OpenSimplexNoise noiseD = new OpenSimplexNoise(rand.nextInt());
        Set positions = Sets.newConcurrentHashSet();
        float a = this.hasCaves(world, new BlockPos(x1, 0, z1)) ? 1.0f : 0.0f;
        float b = this.hasCaves(world, new BlockPos(x2, 0, z1)) ? 1.0f : 0.0f;
        float c = this.hasCaves(world, new BlockPos(x1, 0, z2)) ? 1.0f : 0.0f;
        float d = this.hasCaves(world, new BlockPos(x2, 0, z2)) ? 1.0f : 0.0f;
        ChunkAccess chunk = world.getChunk(cx, cz);
        IntStream.range(0, 256).parallel().forEach(index -> {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int x = index & 0xF;
            int z = index >> 4;
            int wheight = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x, z);
            float dx = (float)x / 16.0f;
            float dz = (float)z / 16.0f;
            pos.setX(x + x1);
            pos.setZ(z + z1);
            float da = Mth.lerp((float)dx, (float)a, (float)b);
            float db = Mth.lerp((float)dx, (float)c, (float)d);
            float density = 1.0f - Mth.lerp((float)dz, (float)da, (float)db);
            if ((double)density < 0.5) {
                for (int y = 0; y < wheight; ++y) {
                    float dist;
                    pos.setY(y);
                    float gradient = 1.0f - Mth.clamp((float)((float)(wheight - y) * 0.1f), (float)0.0f, (float)1.0f);
                    if ((double)gradient > 0.5) break;
                    float val = Mth.abs((float)((float)noiseH.eval((double)pos.getX() * 0.02, (double)y * 0.01, (double)pos.getZ() * 0.02)));
                    float vert = Mth.sin((float)(((float)y + (float)noiseV.eval((double)pos.getX() * 0.01, (double)pos.getZ() * 0.01) * 20.0f) * 0.1f)) * 0.9f;
                    if (!((double)(val = val + vert * vert + (dist = (float)noiseD.eval((double)pos.getX() * 0.1, (double)y * 0.1, (double)pos.getZ() * 0.1) * 0.12f) + density + gradient) < 0.15) || !world.getBlockState((BlockPos)pos).is(CommonBlockTags.END_STONES) || !this.noWaterNear(world, (BlockPos)pos)) continue;
                    positions.add(pos.immutable());
                }
            }
        });
        positions.forEach(bpos -> BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)CAVE_AIR));
        return positions;
    }

    private boolean noWaterNear(WorldGenLevel world, BlockPos pos) {
        BlockPos above1 = pos.above();
        BlockPos above2 = pos.above(2);
        if (!world.getFluidState(above1).isEmpty() || !world.getFluidState(above2).isEmpty()) {
            return false;
        }
        for (Direction dir : BlocksHelper.HORIZONTAL) {
            if (!world.getFluidState(above1.relative(dir)).isEmpty()) {
                return false;
            }
            if (world.getFluidState(above2.relative(dir)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (pos.getX() * pos.getX() + pos.getZ() * pos.getZ() <= 2500) {
            return false;
        }
        if (this.biomeMissingCaves(world, pos)) {
            return false;
        }
        Set<BlockPos> caveBlocks = this.generate(world, pos, random);
        if (caveBlocks.isEmpty()) {
            return false;
        }
        ChunkGenerator generator = featureConfig.chunkGenerator();
        HashMap floorSets = Maps.newHashMap();
        HashMap ceilSets = Maps.newHashMap();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        HashSet remove = Sets.newHashSet();
        caveBlocks.forEach(bpos -> {
            mut.set((Vec3i)bpos);
            WoverBiomePicker.PickableBiome bio = EndBiomes.getCaveBiome(bpos.getX(), bpos.getZ());
            int height = world.getHeight(Heightmap.Types.WORLD_SURFACE, bpos.getX(), bpos.getZ());
            if (mut.getY() >= height) {
                remove.add(bpos);
            } else if (world.getBlockState((BlockPos)mut).canBeReplaced()) {
                mut.setY(bpos.getY() - 1);
                if (world.getBlockState((BlockPos)mut).is(CommonBlockTags.END_STONES)) {
                    Set floorPositions = floorSets.computeIfAbsent(bio, k -> Sets.newHashSet());
                    floorPositions.add(mut.immutable());
                }
                mut.setY(bpos.getY() + 1);
                if (world.getBlockState((BlockPos)mut).is(CommonBlockTags.END_STONES)) {
                    Set ceilPositions = ceilSets.computeIfAbsent(bio, k -> Sets.newHashSet());
                    ceilPositions.add(mut.immutable());
                }
                this.setBiome(world, (BlockPos)bpos, bio);
            }
        });
        caveBlocks.removeAll(remove);
        if (caveBlocks.isEmpty()) {
            return true;
        }
        floorSets.forEach((biome, floorPositions) -> {
            BiomeData patt0$temp = biome.biomeData;
            if (patt0$temp instanceof EndCaveBiome) {
                EndCaveBiome caveBiome = (EndCaveBiome)patt0$temp;
                BlockState surfaceBlock = caveBiome.getTopMaterial();
                this.placeFloor(world, generator, caveBiome, (Set<BlockPos>)floorPositions, random, surfaceBlock);
            } else if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue() && tunnelFloorErrCounter < 25) {
                ++tunnelFloorErrCounter;
                BetterEnd.LOGGER.error(String.valueOf(biome.biome.unwrapKey().map(ResourceKey::location).orElse(null)) + " is not an EndCaveBiome. Unable to place Tunnel Floor");
            }
        });
        ceilSets.forEach((biome, ceilPositions) -> {
            BiomeData patt0$temp = biome.biomeData;
            if (patt0$temp instanceof EndCaveBiome) {
                EndCaveBiome caveBiome = (EndCaveBiome)patt0$temp;
                this.placeCeil(world, generator, caveBiome, (Set<BlockPos>)ceilPositions, random);
            } else if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue() && tunnelCeilErrCounter < 25) {
                ++tunnelCeilErrCounter;
                BetterEnd.LOGGER.error(String.valueOf(biome.biome.unwrapKey().map(ResourceKey::location).orElse(null)) + " is not an EndCaveBiome. Unable to place Tunnel Ceiling");
            }
        });
        WoverBiomePicker.PickableBiome biome2 = EndBiomes.getCaveBiome(pos.getX(), pos.getZ());
        BiomeData biomeData = biome2.biomeData;
        if (biomeData instanceof EndCaveBiome) {
            EndCaveBiome caveBiome = (EndCaveBiome)biomeData;
            this.placeWalls(world, generator, caveBiome, caveBlocks, random);
        } else if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue() && tunnelWallErrCounter < 25) {
            ++tunnelWallErrCounter;
            BetterEnd.LOGGER.error(String.valueOf(biome2.biome.unwrapKey().map(ResourceKey::location).orElse(null)) + " is not an EndCaveBiome. Unable to place Tunnel Walls");
        }
        this.fixBlocks(world, caveBlocks);
        return true;
    }

    @Override
    protected Set<BlockPos> generate(WorldGenLevel world, BlockPos center, int radius, RandomSource random) {
        return null;
    }

    @Override
    protected void placeFloor(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> floorPositions, RandomSource random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity() * 0.2f;
        floorPositions.forEach(pos -> {
            Holder<? extends ConfiguredFeature<?, ?>> feature;
            if (!surfaceBlock.is(Blocks.END_STONE)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)surfaceBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getFloorFeature(random)) != null && feature.isBound()) {
                ((ConfiguredFeature)feature.value()).place(world, generator, random, pos.above());
            }
        });
    }

    @Override
    protected void placeCeil(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> ceilPositions, RandomSource random) {
        float density = biome.getCeilDensity() * 0.2f;
        ceilPositions.forEach(pos -> {
            Holder<? extends ConfiguredFeature<?, ?>> feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)ceilBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getCeilFeature(random)) != null && feature.isBound()) {
                ((ConfiguredFeature)feature.value()).place(world, generator, random, pos.below());
            }
        });
    }

    protected boolean hasCaves(WorldGenLevel world, BlockPos pos) {
        return this.hasCavesInBiome(world, pos.offset(-8, 0, -8)) && this.hasCavesInBiome(world, pos.offset(8, 0, -8)) && this.hasCavesInBiome(world, pos.offset(-8, 0, 8)) && this.hasCavesInBiome(world, pos.offset(8, 0, 8));
    }

    protected boolean hasCavesInBiome(WorldGenLevel world, BlockPos pos) {
        Holder biome = world.getBiome(pos);
        BiomeData biomeData = BiomeManager.biomeDataForHolder((Holder)biome);
        if (biomeData instanceof EndBiome) {
            EndBiome endBiome = (EndBiome)biomeData;
            return endBiome.hasCaves();
        }
        return true;
    }
}

