/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.generator;

import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.world.generator.TerrainGenerator;
import org.betterx.wover.generator.api.biomesource.WoverBiomeSource;
import org.betterx.wover.generator.api.biomesource.end.BiomeDecider;
import org.betterx.wover.generator.api.biomesource.end.WoverEndConfig;
import org.betterx.wover.generator.impl.biomesource.end.WoverEndBiomeSource;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;

public class EndLandBiomeDecider
extends BiomeDecider {
    public EndLandBiomeDecider() {
        super(biome -> false);
    }

    public boolean canProvideFor(BiomeSource source) {
        if (source instanceof WoverEndBiomeSource) {
            WoverEndBiomeSource endSource = (WoverEndBiomeSource)source;
            return endSource.getBiomeSourceConfig().generatorVersion == WoverEndConfig.EndBiomeGeneratorType.PAULEVS;
        }
        return false;
    }

    public BiomeDecider createInstance(WoverBiomeSource biomeSource) {
        return new EndLandBiomeDecider();
    }

    public TagKey<Biome> suggestType(TagKey<Biome> originalType, TagKey<Biome> suggestedType, double density, int maxHeight, int blockX, int blockY, int blockZ, int quarterX, int quarterY, int quarterZ) {
        if (TerrainGenerator.isLand(quarterX, quarterZ, maxHeight).booleanValue()) {
            return suggestedType.equals((Object)CommonBiomeTags.IS_END_CENTER) ? suggestedType : EndTags.IS_END_HIGH_OR_MIDLAND;
        }
        return suggestedType.equals((Object)CommonBiomeTags.IS_END_CENTER) ? CommonBiomeTags.IS_END_BARRENS : CommonBiomeTags.IS_SMALL_END_ISLAND;
    }

    public boolean canProvideBiome(TagKey<Biome> suggestedType) {
        return false;
    }
}

