/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.structures.features.FeatureBaseStructure;
import org.betterx.betterend.world.structures.piece.LakePiece;

public class MegaLakeSmallStructure
extends FeatureBaseStructure {
    public MegaLakeSmallStructure(Structure.StructureSettings s) {
        super(s);
    }

    public StructureType<MegaLakeSmallStructure> type() {
        return EndStructures.MEGALAKE_SMALL.type();
    }

    @Override
    protected void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        RandomState rState = context.randomState();
        int x = chunkPos.getBlockX(MHelper.randRange((int)4, (int)12, (RandomSource)random));
        int z = chunkPos.getBlockZ(MHelper.randRange((int)4, (int)12, (RandomSource)random));
        int y = chunkGenerator.getBaseHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, rState);
        Holder<Biome> biome = this.getNoiseBiome(chunkGenerator, rState, x >> 2, y >> 2, z >> 2);
        if (y > 5) {
            float radius = MHelper.randRange((int)20, (int)40, (RandomSource)random);
            float depth = MHelper.randRange((int)5, (int)10, (RandomSource)random);
            LakePiece piece = new LakePiece(new BlockPos(x, y, z), radius, depth, (RandomSource)random, biome);
            structurePiecesBuilder.addPiece((StructurePiece)piece);
        }
    }
}

