/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.structures.piece.BasePiece;

public abstract class MountainPiece
extends BasePiece {
    protected Map<Integer, Integer> heightmap = Maps.newHashMap();
    protected OpenSimplexNoise noise1;
    protected OpenSimplexNoise noise2;
    protected BlockPos center;
    protected float radius;
    protected float height;
    protected float r2;
    protected ResourceKey<Biome> biomeID;
    protected int seed1;
    protected int seed2;

    public MountainPiece(StructurePieceType type, BlockPos center, float radius, float height, RandomSource random, Holder<Biome> biome) {
        super(type, random.nextInt(), null);
        this.center = center;
        this.radius = radius;
        this.height = height;
        this.r2 = radius * radius;
        this.seed1 = random.nextInt();
        this.seed2 = random.nextInt();
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
        this.biomeID = biome.unwrapKey().orElse(null);
        this.makeBoundingBox();
    }

    public MountainPiece(StructurePieceType type, CompoundTag tag) {
        super(type, tag);
        this.makeBoundingBox();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("center", NbtUtils.writeBlockPos((BlockPos)this.center));
        tag.putFloat("radius", this.radius);
        tag.putFloat("height", this.height);
        tag.putString("biome", this.biomeID.location().toString());
        tag.putInt("seed1", this.seed1);
        tag.putInt("seed2", this.seed2);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        this.center = NbtUtils.readBlockPos((CompoundTag)tag, (String)"center").orElse(BlockPos.ZERO);
        this.radius = tag.getFloat("radius");
        this.height = tag.getFloat("height");
        this.biomeID = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)tag.getString("biome")));
        this.r2 = this.radius * this.radius;
        this.seed1 = tag.getInt("seed1");
        this.seed2 = tag.getInt("seed2");
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
    }

    private int getHeight(WorldGenLevel world, BlockPos pos) {
        int p = (pos.getX() & 0x7FF) << 11 | pos.getZ() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, Integer.MIN_VALUE);
        if (h > Integer.MIN_VALUE) {
            return h;
        }
        if (!world.getBiome(pos).is(this.biomeID)) {
            this.heightmap.put(p, -10);
            return -10;
        }
        h = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ());
        if ((h = Mth.abs((int)(h - this.center.getY()))) > 4) {
            h = 4 - h;
            this.heightmap.put(p, h);
            return h;
        }
        h = MHelper.floor((double)(this.noise2.eval((double)pos.getX() * 0.01, (double)pos.getZ() * 0.01) * this.noise2.eval((double)pos.getX() * 0.002, (double)pos.getZ() * 0.002) * 8.0 + 8.0));
        if (h < 0) {
            this.heightmap.put(p, 0);
            return 0;
        }
        this.heightmap.put(p, h);
        return h;
    }

    protected float getHeightClamp(WorldGenLevel world, int radius, int posX, int posZ) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.setX(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.setZ(posZ + z);
                int z2 = z * z;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                if (!(mult > 0.0f)) continue;
                max += mult;
                height += (float)this.getHeight(world, (BlockPos)mut) * mult;
            }
        }
        return Mth.clamp((float)((height /= max) / (float)radius), (float)0.0f, (float)1.0f);
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.getX() - this.radius));
        int minY = MHelper.floor((double)((float)this.center.getY() - this.radius));
        int minZ = MHelper.floor((double)((float)this.center.getZ() - this.radius));
        int maxX = MHelper.floor((double)((float)this.center.getX() + this.radius + 1.0f));
        int maxY = MHelper.floor((double)((float)this.center.getY() + this.radius + 1.0f));
        int maxZ = MHelper.floor((double)((float)this.center.getZ() + this.radius + 1.0f));
        this.boundingBox = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

