/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.util.BlocksHelper;

public class StructureWorldNBT
extends StructureNBT {
    public static final Codec<StructureWorldNBT> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(cfg -> cfg.location), (App)Codec.INT.fieldOf("offset_y").orElse((Object)0).forGetter(cfg -> cfg.offsetY), (App)StructurePlacementType.CODEC.fieldOf("placement").orElse((Object)StructurePlacementType.FLOOR).forGetter(cfg -> cfg.type), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(cfg -> Float.valueOf(cfg.chance))).apply((Applicative)instance, StructureWorldNBT::new));
    public final StructurePlacementType type;
    public final int offsetY;
    public final float chance;
    private static final Map<String, StructureWorldNBT> READER_CACHE = Maps.newHashMap();

    protected StructureWorldNBT(ResourceLocation location, int offsetY, StructurePlacementType type, float chance) {
        super(location);
        this.offsetY = offsetY;
        this.type = type;
        this.chance = chance;
    }

    public static StructureWorldNBT create(ResourceLocation location, int offsetY, StructurePlacementType type) {
        return StructureWorldNBT.create(location, offsetY, type, 1.0f);
    }

    public static StructureWorldNBT create(ResourceLocation location, int offsetY, StructurePlacementType type, float chance) {
        String key = location.toString() + "::" + offsetY + "::" + type.getSerializedName();
        return READER_CACHE.computeIfAbsent(key, r -> new StructureWorldNBT(location, offsetY, type, chance));
    }

    public boolean generateIfPlaceable(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        return this.generateIfPlaceable(level, pos, StructureWorldNBT.getRandomRotation(random), StructureWorldNBT.getRandomMirror(random));
    }

    public boolean generateIfPlaceable(ServerLevelAccessor level, BlockPos pos, Rotation r, Mirror m) {
        if (this.canGenerate((LevelAccessor)level, pos, r)) {
            return this.generate(level, pos, r, m);
        }
        return false;
    }

    public boolean generate(ServerLevelAccessor level, BlockPos pos, Rotation r, Mirror m) {
        return this.generateCentered(level, pos.above(this.offsetY), r, m);
    }

    protected boolean canGenerate(LevelAccessor level, BlockPos pos, Rotation rotation) {
        if (this.type == StructurePlacementType.FLOOR) {
            return this.canGenerateFloor(level, pos, rotation);
        }
        if (this.type == StructurePlacementType.LAVA) {
            return this.canGenerateLava(level, pos, rotation);
        }
        if (this.type == StructurePlacementType.UNDER) {
            return this.canGenerateUnder(level, pos, rotation);
        }
        if (this.type == StructurePlacementType.CEIL) {
            return this.canGenerateCeil(level, pos, rotation);
        }
        return false;
    }

    private boolean containsBedrock(LevelAccessor level, BlockPos startPos) {
        for (int i = 0; i < this.structure.getSize().getY(); i += 2) {
            if (!level.getBlockState(startPos.above(i)).is(Blocks.BEDROCK)) continue;
            return true;
        }
        return false;
    }

    protected boolean canGenerateFloorFreeAbove(LevelAccessor world, BlockPos pos, Rotation rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getAirFractionFoundation(world, pos, rotation) < 0.5 && world.getBlockState(pos.above(2)).is(Blocks.AIR) && world.getBlockState(pos.above(4)).is(Blocks.AIR);
    }

    protected boolean canGenerateFloor(LevelAccessor world, BlockPos pos, Rotation rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getAirFraction(world, pos, rotation) > 0.6 && (double)this.getAirFractionFoundation(world, pos, rotation) < 0.5;
    }

    protected boolean canGenerateLava(LevelAccessor world, BlockPos pos, Rotation rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getLavaFractionFoundation(world, pos, rotation) > 0.9 && (double)this.getAirFraction(world, pos, rotation) > 0.9;
    }

    protected boolean canGenerateUnder(LevelAccessor world, BlockPos pos, Rotation rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getAirFraction(world, pos, rotation) < 0.2;
    }

    protected boolean canGenerateCeil(LevelAccessor world, BlockPos pos, Rotation rotation) {
        if (this.containsBedrock(world, pos)) {
            return false;
        }
        return (double)this.getAirFractionBottom(world, pos, rotation) > 0.8 && (double)this.getAirFraction(world, pos, rotation) < 0.6;
    }

    public BoundingBox boundingBox(Rotation r, BlockPos p) {
        return this.getBoundingBox(p, r, Mirror.NONE);
    }

    protected float getAirFraction(LevelAccessor world, BlockPos pos, Rotation rotation) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int airCount = 0;
        BlockPos.MutableBlockPos size = new BlockPos.MutableBlockPos().set((Vec3i)new BlockPos(this.structure.getSize()).rotate(rotation));
        size.setX(Math.abs(size.getX()) >> 1);
        size.setZ(Math.abs(size.getZ()) >> 1);
        BlockPos start = pos.offset(-size.getX(), 0, -size.getZ());
        BlockPos end = pos.offset(size.getX(), size.getY() + this.offsetY, size.getZ());
        int count = 0;
        for (int x = start.getX(); x <= end.getX(); ++x) {
            POS.setX(x);
            for (int y = start.getY(); y <= end.getY(); ++y) {
                POS.setY(y);
                for (int z = start.getZ(); z <= end.getZ(); ++z) {
                    POS.setZ(z);
                    if (world.isEmptyBlock((BlockPos)POS)) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    private float getLavaFractionFoundation(LevelAccessor world, BlockPos pos, Rotation rotation) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int lavaCount = 0;
        BlockPos.MutableBlockPos size = new BlockPos.MutableBlockPos().set((Vec3i)new BlockPos(this.structure.getSize()).rotate(rotation));
        size.setX(Math.abs(size.getX()) >> 1);
        size.setZ(Math.abs(size.getZ()) >> 1);
        BlockPos start = pos.offset(-size.getX(), 0, -size.getZ());
        BlockPos end = pos.offset(size.getX(), 0, size.getZ());
        int count = 0;
        POS.setY(pos.getY() - 1);
        for (int x = start.getX(); x <= end.getX(); ++x) {
            POS.setX(x);
            for (int z = start.getZ(); z <= end.getZ(); ++z) {
                POS.setZ(z);
                if (BlocksHelper.isLava(world.getBlockState((BlockPos)POS))) {
                    ++lavaCount;
                }
                ++count;
            }
        }
        return (float)lavaCount / (float)count;
    }

    private float getAirFractionFoundation(LevelAccessor world, BlockPos pos, Rotation rotation) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int airCount = 0;
        BlockPos.MutableBlockPos size = new BlockPos.MutableBlockPos().set((Vec3i)new BlockPos(this.structure.getSize()).rotate(rotation));
        size.setX(Math.abs(size.getX()) >> 1);
        size.setZ(Math.abs(size.getZ()) >> 1);
        BlockPos start = pos.offset(-size.getX(), -1, -size.getZ());
        BlockPos end = pos.offset(size.getX(), 0, size.getZ());
        int count = 0;
        for (int x = start.getX(); x <= end.getX(); ++x) {
            POS.setX(x);
            for (int y = start.getY(); y <= end.getY(); ++y) {
                POS.setY(y);
                for (int z = start.getZ(); z <= end.getZ(); ++z) {
                    POS.setZ(z);
                    if (world.getBlockState((BlockPos)POS).canBeReplaced()) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    private float getAirFractionBottom(LevelAccessor world, BlockPos pos, Rotation rotation) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int airCount = 0;
        BlockPos.MutableBlockPos size = new BlockPos.MutableBlockPos().set((Vec3i)new BlockPos(this.structure.getSize()).rotate(rotation));
        size.setX(Math.abs(size.getX()));
        size.setZ(Math.abs(size.getZ()));
        float y1 = Math.min(this.offsetY, 0);
        float y2 = Math.max(this.offsetY, 0);
        BlockPos start = pos.offset(-(size.getX() >> 1), (int)y1, -(size.getZ() >> 1));
        BlockPos end = pos.offset(size.getX() >> 1, (int)y2, size.getZ() >> 1);
        int count = 0;
        for (int x = start.getX(); x <= end.getX(); ++x) {
            POS.setX(x);
            for (int y = start.getY(); y <= end.getY(); ++y) {
                POS.setY(y);
                for (int z = start.getZ(); z <= end.getZ(); ++z) {
                    POS.setZ(z);
                    if (world.getBlockState((BlockPos)POS).canBeReplaced()) {
                        ++airCount;
                    }
                    ++count;
                }
            }
        }
        return (float)airCount / (float)count;
    }

    public boolean loaded() {
        return this.structure != null;
    }
}

