/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.spawning;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import org.betterx.bclib.api.v2.spawning.SpawnRuleEntry;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.bclib.interfaces.SpawnRule;
import org.betterx.bclib.util.BlocksHelper;

@EventBusSubscriber(modid="bclib", bus=EventBusSubscriber.Bus.MOD)
public class SpawnRuleBuilder<M extends Mob> {
    private static final Map<String, SpawnRuleEntry> RULES_CACHE = Maps.newHashMap();
    private static final SpawnRuleBuilder INSTANCE = new SpawnRuleBuilder();
    private static final List<SpawnPlacementEntry<?>> PENDING = new ArrayList();
    private final List<SpawnRuleEntry> rules = Lists.newArrayList();
    private SpawnRuleEntry entryInstance;
    private EntityType<M> entityType;

    private SpawnRuleBuilder() {
    }

    public static SpawnRuleBuilder start(EntityType<? extends Mob> entityType) {
        SpawnRuleBuilder.INSTANCE.entityType = entityType;
        SpawnRuleBuilder.INSTANCE.rules.clear();
        return INSTANCE;
    }

    public static SpawnRuleBuilder start(BCLEntityWrapper<? extends Mob> wrapper) {
        SpawnRuleBuilder builder = SpawnRuleBuilder.start(wrapper.type());
        if (!wrapper.canSpawn()) {
            builder.preventSpawn();
        }
        return builder;
    }

    public SpawnRuleBuilder preventSpawn() {
        this.entryInstance = SpawnRuleBuilder.getFromCache("prevent", () -> new SpawnRuleEntry(-1, (type, world, spawnReason, pos, random) -> false, "Prevent Spawn"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder notPeaceful() {
        this.entryInstance = SpawnRuleBuilder.getFromCache("not_peaceful", () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL, "Not Peaceful"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder aboveGround(int minHeight) {
        this.entryInstance = SpawnRuleBuilder.getFromCache("above_ground", () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> {
            if (pos.getY() < world.getMinBuildHeight() + 2) {
                return false;
            }
            return BlocksHelper.findSurfaceBelow(world, pos, pos.getY() - minHeight, bs -> !BlocksHelper.isFree(bs)).isEmpty();
        }, "Above Ground"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder belowMaxHeight() {
        this.entryInstance = SpawnRuleBuilder.getFromCache("below_max_height", () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> pos.getY() < world.dimensionType().logicalHeight(), "Below Max Height"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder onlyOnValidBlocks() {
        this.entryInstance = SpawnRuleBuilder.getFromCache("only_on_valid_blocks", () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> {
            BlockPos below = pos.below();
            return world.getBlockState(below).isValidSpawn((BlockGetter)world, below, type);
        }, "Only On Valid Blocks"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder onlyOnBlocks(Block ... blocks) {
        Block[] floorBlocks = blocks;
        Arrays.sort(floorBlocks, Comparator.comparing(Block::getDescriptionId));
        StringBuilder builder = new StringBuilder("only_on_blocks");
        for (Block block : floorBlocks) {
            builder.append('_');
            builder.append(block.getDescriptionId());
        }
        this.entryInstance = SpawnRuleBuilder.getFromCache(builder.toString(), () -> new SpawnRuleEntry(0, (type, world, spawnReason, pos, random) -> {
            Block below = world.getBlockState(pos.below()).getBlock();
            for (Block floor : floorBlocks) {
                if (floor != below) continue;
                return true;
            }
            return false;
        }, "Only On Blocks"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder withChance(int chance) {
        this.entryInstance = SpawnRuleBuilder.getFromCache("with_chance_" + chance, () -> new SpawnRuleEntry(1, (type, world, spawnReason, pos, random) -> random.nextInt(chance) == 0, "With Chance"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder belowBrightness(int lightLevel) {
        this.entryInstance = SpawnRuleBuilder.getFromCache("below_brightness_" + lightLevel, () -> new SpawnRuleEntry(2, (type, world, spawnReason, pos, random) -> world.getMaxLocalRawBrightness(pos) <= lightLevel, "Below Brightness"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder aboveBrightness(int lightLevel) {
        this.entryInstance = SpawnRuleBuilder.getFromCache("above_brightness_" + lightLevel, () -> new SpawnRuleEntry(2, (type, world, spawnReason, pos, random) -> world.getMaxLocalRawBrightness(pos) >= lightLevel, "Above Brightness"));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder hostile(int lightLevel) {
        return this.notPeaceful().belowBrightness(lightLevel);
    }

    public SpawnRuleBuilder vanillaHostile() {
        return this.hostile(7);
    }

    public SpawnRuleBuilder maxNearby(EntityType<?> selectorType, int count, int side) {
        Class baseClass = selectorType.getBaseClass();
        this.entryInstance = SpawnRuleBuilder.getFromCache("max_nearby_" + selectorType.getDescriptionId() + "_" + count + "_" + side, () -> new SpawnRuleEntry(3, (type, world, spawnReason, pos, random) -> {
            try {
                AABB box = new AABB(pos).inflate((double)side, (double)world.getHeight(), (double)side);
                List list = world.getEntitiesOfClass(baseClass, box, entity -> true);
                return list.size() < count;
            }
            catch (Exception e) {
                return true;
            }
        }, "Max Nearby " + count + "/" + side));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SpawnRuleBuilder maxNearby(int count, int side) {
        return this.maxNearby(this.entityType, count, side);
    }

    public SpawnRuleBuilder maxNearby(int count) {
        return this.maxNearby(this.entityType, count, 256);
    }

    public SpawnRuleBuilder customRule(SpawnRule rule) {
        this.rules.add(new SpawnRuleEntry(7, rule, "Custom Rule"));
        return this;
    }

    public void build(SpawnPlacementType spawnType, Heightmap.Types heightmapType) {
        ArrayList rulesCopy = Lists.newArrayList(this.rules);
        Collections.sort(rulesCopy);
        SpawnPlacements.SpawnPredicate predicate = (entityType, serverLevelAccessor, mobSpawnType, blockPos, random) -> {
            for (SpawnRuleEntry rule : rulesCopy) {
                if (rule.canSpawn(entityType, (LevelAccessor)serverLevelAccessor, mobSpawnType, blockPos, random)) continue;
                return false;
            }
            return true;
        };
        PENDING.add(new SpawnPlacementEntry<M>(this.entityType, spawnType, heightmapType, predicate));
    }

    public void buildNoRestrictions(Heightmap.Types heightmapType) {
        this.build(SpawnPlacementTypes.NO_RESTRICTIONS, heightmapType);
    }

    public void buildOnGround(Heightmap.Types heightmapType) {
        this.build(SpawnPlacementTypes.ON_GROUND, heightmapType);
    }

    public void buildInWater(Heightmap.Types heightmapType) {
        this.build(SpawnPlacementTypes.IN_WATER, heightmapType);
    }

    public void buildInLava(Heightmap.Types heightmapType) {
        this.build(SpawnPlacementTypes.IN_LAVA, heightmapType);
    }

    private static SpawnRuleEntry getFromCache(String name, Supplier<SpawnRuleEntry> supplier) {
        return supplier.get();
    }

    @SubscribeEvent
    public static void onRegisterSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        for (SpawnPlacementEntry<?> entry : PENDING) {
            SpawnRuleBuilder.registerEntry(event, entry);
        }
        PENDING.clear();
    }

    private static <T extends Mob> void registerEntry(RegisterSpawnPlacementsEvent event, SpawnPlacementEntry<T> entry) {
        event.register(entry.entityType(), entry.spawnType(), entry.heightmapType(), entry.predicate(), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    private record SpawnPlacementEntry<T extends Mob>(EntityType<T> entityType, SpawnPlacementType spawnType, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
    }
}

