/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.betterx.wover.tag.api.predefined.CommonItemTags;

public abstract class BaseCraftingTableBlock
extends CraftingTableBlock
implements DropSelfLootProvider<BaseCraftingTableBlock>,
BlockModelProvider,
BlockTagProvider,
ItemTagProvider {
    protected BaseCraftingTableBlock(Block source) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source));
    }

    protected BaseCraftingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static TextureMapping craftingTableTextureMapping(Block block, Block block2) {
        return new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)block, (String)"_front")).put(TextureSlot.DOWN, TextureMapping.getBlockTexture((Block)block2, (String)"_bottom")).put(TextureSlot.UP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.NORTH, TextureMapping.getBlockTexture((Block)block, (String)"_front")).put(TextureSlot.EAST, TextureMapping.getBlockTexture((Block)block, (String)"_side")).put(TextureSlot.SOUTH, TextureMapping.getBlockTexture((Block)block, (String)"_side")).put(TextureSlot.WEST, TextureMapping.getBlockTexture((Block)block, (String)"_front"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.vanillaGenerator.createCraftingTableLike((Block)this, (Block)this, BaseCraftingTableBlock::craftingTableTextureMapping);
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add(CommonBlockTags.WORKBENCHES, (Object[])new Block[]{this});
    }

    public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
        context.add((ItemLike)this, new TagKey[]{CommonItemTags.WORKBENCHES});
    }

    public static BaseCraftingTableBlock from(Block source) {
        return new Wood(source);
    }

    public static class Wood
    extends BaseCraftingTableBlock
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }

        public Wood(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

