/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.BasePlantBlock;
import org.betterx.bclib.blocks.BlockProperties;

public abstract class BasePlantWithAgeBlock
extends BasePlantBlock {
    public static final IntegerProperty AGE = BlockProperties.AGE;

    protected BasePlantWithAgeBlock(BlockBehaviour.Properties settings) {
        super(settings.randomTicks());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{AGE});
    }

    public abstract void growAdult(WorldGenLevel var1, RandomSource var2, BlockPos var3);

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 3) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        } else {
            this.growAdult((WorldGenLevel)level, random, pos);
        }
    }

    @Override
    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        if (random.nextInt(8) == 0) {
            this.performBonemeal(world, random, pos, state);
        }
    }
}

