/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.AbstractVineBlock;
import org.betterx.bclib.blocks.BlockProperties;

public class BaseSimpleVineBlock
extends AbstractVineBlock {
    public static final BooleanProperty BOTTOM = BlockProperties.BOTTOM;

    public BaseSimpleVineBlock(BlockBehaviour.Properties properties, int maxGrowLength, int spaceBeneath) {
        super(properties, maxGrowLength, spaceBeneath, 0);
    }

    private BaseSimpleVineBlock(BlockBehaviour.Properties properties, int maxGrowLength, int spaceBeneath, int growChance) {
        super(properties, maxGrowLength, spaceBeneath, growChance);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BOTTOM});
    }

    @Override
    protected BlockState makeBottomState(BlockState state) {
        return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true));
    }

    @Override
    protected BlockState makeMiddleState(BlockState state) {
        return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected BlockState makeTopState(BlockState state) {
        return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false));
    }

    public static class Growing
    extends BaseSimpleVineBlock {
        public Growing(BlockBehaviour.Properties properties, int maxGrowLength, int spaceBeneath, int growChance) {
            super(properties.randomTicks(), maxGrowLength, spaceBeneath, growChance);
        }

        public boolean isRandomlyTicking(BlockState state) {
            return (Boolean)state.getValue((Property)BOTTOM);
        }
    }
}

