/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseWallPlantBlock;

public abstract class WallMushroomBlock
extends BaseWallPlantBlock {
    public WallMushroomBlock(int light) {
        super(BehaviourBuilders.createPlant().destroyTime(0.2f).lightLevel(state -> light).sound(SoundType.WOOD));
    }

    protected WallMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
    }

    @Override
    public boolean isSupport(LevelReader world, BlockPos pos, BlockState blockState, Direction direction) {
        return blockState.isSolid() && blockState.isFaceSturdy((BlockGetter)world, pos, direction);
    }
}

